/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrFactory;
import org.apache.jena.dboe.base.block.BlockMgrLogger;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelMem;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTStateMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecordsMgr;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.BlockTracker;
import org.apache.jena.dboe.transaction.txn.ComponentId;

public class BPlusTreeFactory {
    private BPlusTreeFactory() {
    }

    public static BPlusTree create(ComponentId id, BPlusTreeParams params, BufferChannel chan, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        if (id == null) {
            id = ComponentId.allocLocal();
        }
        BPlusTree bpt = BPlusTreeFactory.attach(id, params, false, chan, blkMgrNodes, blkMgrLeaves);
        return bpt;
    }

    public static BPlusTree createNonTxn(BPlusTreeParams params, BufferChannel chan, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        BPlusTree bpt = BPlusTreeFactory.create(null, params, chan, blkMgrNodes, blkMgrLeaves);
        bpt.nonTransactional();
        return bpt;
    }

    public static BPlusTree rebuild(BPlusTree bpt, BufferChannel chan, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        if (chan == null) {
            chan = bpt.getStateManager().getBufferChannel();
        }
        if (blkMgrNodes == null) {
            blkMgrNodes = bpt.getNodeManager().getBlockMgr();
        }
        if (blkMgrLeaves == null) {
            blkMgrLeaves = bpt.getNodeManager().getBlockMgr();
        }
        BPlusTree bpt2 = BPlusTreeFactory.attach(bpt.getComponentId(), bpt.getParams(), true, chan, blkMgrNodes, blkMgrLeaves);
        return bpt2;
    }

    public static RangeIndex makeBPlusTree(ComponentId cid, FileSet fs, int blkSize, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        RecordFactory recordFactory = BPlusTreeFactory.makeRecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        BPlusTree rIndex = BPlusTreeFactory.createBPTree(cid, fs, order, blkSize, readCacheSize, writeCacheSize, recordFactory);
        return rIndex;
    }

    public static RecordFactory makeRecordFactory(int keyLen, int valueLen) {
        return new RecordFactory(keyLen, valueLen);
    }

    public static BPlusTree createBPTree(ComponentId cid, FileSet fileset, RecordFactory factory) {
        int readCacheSize = SystemIndex.BlockReadCacheSize;
        int writeCacheSize = SystemIndex.BlockWriteCacheSize;
        int blockSize = 8192;
        if (fileset.isMem()) {
            readCacheSize = 0;
            writeCacheSize = 0;
            blockSize = 1024;
        }
        return BPlusTreeFactory.createBPTreeByBlockSize(cid, fileset, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTreeByBlockSize(ComponentId cid, FileSet fileset, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return BPlusTreeFactory.createBPTree(cid, fileset, -1, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTreeByOrder(ComponentId cid, FileSet fileset, int order, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return BPlusTreeFactory.createBPTree(cid, fileset, order, -1, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTreeByOrder(ComponentId cid, FileSet fileset, int order, RecordFactory factory) {
        return BPlusTreeFactory.createBPTree(cid, fileset, order, -1, SystemIndex.BlockReadCacheSize, SystemIndex.BlockWriteCacheSize, factory);
    }

    public static BPlusTree createBPTree(ComponentId cid, FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        int order2;
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        if (blockSize < 0 && order >= 0) {
            blockSize = BPlusTreeParams.calcBlockSize(order, factory);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BufferChannel bptState = FileFactory.createBufferChannel((FileSet)fileset, (String)"bpt");
        BlockMgr blkMgrNodes = BlockMgrFactory.create((FileSet)fileset, (String)"idn", (int)blockSize, (int)readCacheSize, (int)writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create((FileSet)fileset, (String)"dat", (int)blockSize, (int)readCacheSize, (int)writeCacheSize);
        return BPlusTreeFactory.create(cid, params, bptState, blkMgrNodes, blkMgrRecords);
    }

    private static BPlusTree attach(ComponentId cid, BPlusTreeParams params, boolean isReset, BufferChannel rootData, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        BPlusTree bpt = new BPlusTree(cid, params);
        BPTStateMgr stateMgr = new BPTStateMgr(rootData);
        blkMgrNodes.resetAlloc(stateMgr.getNodeBlocksLimit());
        blkMgrRecords.resetAlloc(stateMgr.getRecordsBlocksLimit());
        BPTreeNodeMgr nodeManager = new BPTreeNodeMgr(bpt, blkMgrNodes);
        RecordBufferPageMgr recordPageMgr = new RecordBufferPageMgr(params.getRecordFactory(), blkMgrRecords);
        BPTreeRecordsMgr recordsMgr = new BPTreeRecordsMgr(bpt, params.getRecordFactory(), recordPageMgr);
        BPlusTreeFactory.createIfAbsent(isReset, stateMgr, nodeManager, recordsMgr);
        bpt.init(stateMgr, nodeManager, recordsMgr);
        if (BPT.CheckingNode) {
            nodeManager.startRead();
            BPTreeNode root = nodeManager.getRead(bpt.getRootId(), -2);
            root.checkNodeDeep();
            nodeManager.release(root);
            nodeManager.finishRead();
        }
        return bpt;
    }

    public static BPlusTree makeMem(int order, int keyLength, int valueLength) {
        return BPlusTreeFactory.makeMem(null, order, keyLength, valueLength);
    }

    public static BPlusTree makeMem(String name, int order, int keyLength, int valueLength) {
        return BPlusTreeFactory.makeMem(name, order, -1, keyLength, valueLength);
    }

    public static BPlusTree makeMem(int order, int minDataRecords, int keyLength, int valueLength) {
        return BPlusTreeFactory.makeMem(null, order, minDataRecords, keyLength, valueLength);
    }

    public static BPlusTree makeMem(String name, int order, int minDataRecords, int keyLength, int valueLength) {
        int blkSize;
        if (name == null) {
            name = "Mem";
        }
        BPlusTreeParams params = new BPlusTreeParams(order, keyLength, valueLength);
        if (minDataRecords > 0) {
            int maxDataRecords = 2 * minDataRecords;
            blkSize = RecordBufferPage.calcBlockSize((RecordFactory)params.getRecordFactory(), (int)maxDataRecords);
        } else {
            blkSize = params.getCalcBlockSize();
        }
        BufferChannel chan = BufferChannelMem.create((String)(name + "(root)"));
        BlockMgr mgr1 = BlockMgrFactory.createMem((String)(name + "(nodes)"), (int)params.getCalcBlockSize());
        BlockMgr mgr2 = BlockMgrFactory.createMem((String)(name + "(records)"), (int)blkSize);
        ComponentId cid = ComponentId.allocLocal();
        BPlusTree bpTree = BPlusTreeFactory.create(cid, params, chan, mgr1, mgr2);
        return bpTree;
    }

    public static BPlusTree addTracking(BPlusTree bpTree) {
        BufferChannel mgrRoot = null;
        BlockMgr mgr1 = bpTree.getNodeManager().getBlockMgr();
        BlockMgr mgr2 = bpTree.getRecordsMgr().getBlockMgr();
        mgr1 = BlockTracker.track(mgr1);
        mgr2 = BlockTracker.track(mgr2);
        return BPlusTreeFactory.rebuild(bpTree, mgrRoot, mgr1, mgr2);
    }

    public static BPlusTree addLogging(BPlusTree bpTree) {
        BufferChannel mgrRoot = null;
        BlockMgr mgr1 = bpTree.getNodeManager().getBlockMgr();
        BlockMgr mgr2 = bpTree.getRecordsMgr().getBlockMgr();
        mgr1 = new BlockMgrLogger(mgr1, false);
        mgr2 = new BlockMgrLogger(mgr2, false);
        return BPlusTreeFactory.rebuild(bpTree, mgrRoot, mgr1, mgr2);
    }

    private static int createIfAbsent(boolean isReset, BPTStateMgr stateMgr, BPTreeNodeMgr nodeManager, BPTreeRecordsMgr recordsMgr) {
        int rootId = stateMgr.getRoot();
        if (nodeManager.getBlockMgr().isEmpty() != recordsMgr.getBlockMgr().isEmpty()) {
            throw new BPTreeException("Node block manager empty = " + nodeManager.getBlockMgr().isEmpty() + " // Records block manager empty = " + recordsMgr.getBlockMgr().isEmpty());
        }
        if (!nodeManager.getBlockMgr().isEmpty()) {
            return rootId;
        }
        int rootIdx = BPlusTreeFactory.createEmptyBPT(stateMgr, nodeManager, recordsMgr);
        if (rootIdx != 0) {
            throw new InternalError();
        }
        stateMgr.sync();
        nodeManager.getBlockMgr().sync();
        recordsMgr.getBlockMgr().sync();
        return rootIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createEmptyBPT(BPTStateMgr stateMgr, BPTreeNodeMgr nodeManager, BPTreeRecordsMgr recordsMgr) {
        nodeManager.startUpdate();
        recordsMgr.startUpdate();
        stateMgr.setState(0, 0L, 0L);
        try {
            BPTreeRecords recordsPage = recordsMgr.create();
            if (recordsPage.getId() != 0) {
                throw new DBOpEnvException("Root blocks must be at position zero (got " + recordsPage.getId() + ")");
            }
            recordsMgr.write(recordsPage);
            recordsMgr.release(recordsPage);
            BPTreeNode n = nodeManager.createNode(-2);
            n.ptrs.setSize(0);
            n.ptrs.add(recordsPage.getId());
            n.setIsLeaf(true);
            n.setCount(0);
            int rootId = n.getId();
            nodeManager.write(n);
            nodeManager.release(n);
            stateMgr.setState(0, 1L, 1L);
            int n2 = rootId;
            return n2;
        }
        finally {
            recordsMgr.finishUpdate();
            nodeManager.finishUpdate();
        }
    }
}

