/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.jena.irix.IRIs;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.riot.RiotException;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class InputValidator {
    public static boolean checkBoolean(Object boolCheck) {
        String checkBool = boolCheck.toString().toLowerCase();
        return "true".equals(checkBool) || "false".equals(checkBool);
    }

    public static boolean checkIfValidIRI(String iriStr) {
        boolean f = false;
        try {
            f = IRIs.check(iriStr);
        }
        catch (RiotException ex) {
            throw new RiotException();
        }
        catch (Exception ex) {
            throw new JPSRuntimeException("");
        }
        return f && InputValidator.checkIfURLpattern(iriStr);
    }

    public static boolean checkIfURLpattern(String iriStr) {
        try {
            URL url = new URL(iriStr);
            url.toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean checkIfFilePath(String filePath) {
        File file = new File(filePath);
        return file.isFile();
    }

    public static boolean checkIfValidFile(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean checkIfFileGotUpdated(String filePath, long timeLast) {
        if (InputValidator.checkIfValidFile(filePath)) {
            File file = new File(filePath);
            long timeModified = file.lastModified();
            return timeModified > timeLast;
        }
        return false;
    }

    public static boolean checkIfInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean checkIfValidJSONObject(String str) {
        try {
            new JSONObject(str);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    public static boolean checkIfValidQuery(String str) {
        try {
            QueryFactory.create(str);
            return true;
        }
        catch (QueryParseException e) {
            return false;
        }
    }

    public static boolean checkIfValidUpdate(String str) {
        try {
            UpdateFactory.create(str);
            return true;
        }
        catch (UpdateException e) {
            return false;
        }
        catch (QueryParseException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

