/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.cache.LRUCache;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.query.FileBasedStoreClient;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.router.AbstractCachedRouter;
import uk.ac.cam.cares.jps.base.util.InputValidator;
import uk.ac.cam.cares.jps.base.util.MiscUtil;

public class StoreRouter
extends AbstractCachedRouter<String, List<String>> {
    public static final Logger LOGGER = LogManager.getLogger(StoreRouter.class);
    public static final String FILE = "file://";
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String KB = "kb";
    public static final String SLASH = "/";
    public static final String HTTP_KB_PREFIX = "http://".concat("kb").concat("/");
    public static final String EMPTY = "";
    public static final String RDFS_PREFIX = "rdfs";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDF_PREFIX = "rdf";
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_TYPE = "type";
    public static final String ONTOKGROUTER_PREFIX = "ontokgrouter";
    public static final String ONTOKGROUTER = "http://www.theworldavatar.com/ontology/ontokgrouter/OntoKGRouter.owl#";
    public static final String RESOURCE = "resource";
    public static final String LABEL = "label";
    public static final String QUERY_ENDPOINT = "queryEndpoint";
    public static final String HAS_QUERY_ENDPOINT = "hasQueryEndpoint";
    public static final String UPDATE_ENDPOINT = "updateEndpoint";
    public static final String HAS_UPDATE_ENDPOINT = "hasUpdateEndpoint";
    public static final String FILE_PATH = "filePath";
    public static final String HAS_FILE_PATH = "hasFilePath";
    public static final String TOMCAT_ROOT_LABEL = "tomcatrootpath";
    public static final String COLON = ":";
    public static final String QUESTION_MARK = "?";
    public static final String TARGET_RESOURCE = "TargetResource";
    public static final List<String> FILE_EXTENSIONS = Arrays.asList(".owl", ".rdf", ".nt");
    public static final String STOREROUTER_ENDPOINT_NAME = "STOREROUTER_ENDPOINT";
    public static String storeRouterEndpoint = System.getenv("STOREROUTER_ENDPOINT");
    private static final int CACHE_SIZE;
    private static final int QUERY_INDEX = 0;
    private static final int UPDATE_INDEX = 1;
    private static StoreRouter storeRouter;

    private StoreRouter() {
        super(new LRUCache(CACHE_SIZE));
    }

    public static synchronized StoreRouter getInstance() {
        if (storeRouter == null) {
            storeRouter = new StoreRouter();
        }
        return storeRouter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TripleStoreClientInterface getStoreClient(String targetResourceID, boolean isQueryOperation, boolean isUpdateOperation) {
        String queryIRI = null;
        String updateIRI = null;
        TripleStoreClientInterface kbClient = null;
        if (targetResourceID != null && !targetResourceID.isEmpty()) {
            StoreRouter.getInstance();
            if (StoreRouter.isFileBasedTargetResourceID(targetResourceID)) {
                String relativePath = StoreRouter.getPathComponent(targetResourceID);
                String rootPath = StoreRouter.getPathComponent(storeRouter.getLocalFilePath(TOMCAT_ROOT_LABEL, storeRouter.getRouterStoreClient()));
                String filePath = StoreRouter.joinPaths(rootPath, relativePath);
                LOGGER.info("File based resource. file path=" + filePath);
                return new FileBasedStoreClient(filePath);
            }
            if (!StoreRouter.isRemoteTargetResourceID(targetResourceID)) throw new JPSRuntimeException("Invalid targetResourceID: " + targetResourceID);
            String targetResourceLabel = StoreRouter.getLabelFromTargetResourceID(targetResourceID);
            LOGGER.info("Remote store. targetResourceLabel=" + targetResourceLabel);
            List endpoints = (List)storeRouter.get(targetResourceLabel);
            if (endpoints != null) {
                if (isQueryOperation) {
                    queryIRI = (String)endpoints.get(0);
                }
                if (isUpdateOperation) {
                    updateIRI = (String)endpoints.get(1);
                }
                if (queryIRI != null && !queryIRI.isEmpty()) {
                    kbClient = new RemoteStoreClient(queryIRI);
                }
                if (updateIRI != null && !updateIRI.isEmpty()) {
                    if (kbClient == null) {
                        kbClient = new RemoteStoreClient();
                    }
                    kbClient.setUpdateEndpoint(updateIRI);
                }
            }
            if (queryIRI == null && updateIRI == null) {
                LOGGER.error("Endpoint could not be retrieved for the following resource IRI:" + targetResourceID + ", label:" + targetResourceLabel);
            }
            if (isQueryOperation) return kbClient;
            if (isUpdateOperation) return kbClient;
            LOGGER.error("null will be returned as both the isQueryOperation and isUpdateOperation parameters are set to false.");
            return kbClient;
        } else {
            LOGGER.error("targetResourceID is null.");
        }
        return kbClient;
    }

    @Override
    public TripleStoreClientInterface getRouterStoreClient() {
        return new RemoteStoreClient(storeRouterEndpoint);
    }

    @Override
    public List<String> getFromStore(String targetResourceLabel, TripleStoreClientInterface storeClient) {
        ExprFactory exprFactory = new ExprFactory();
        E_Regex exprRegex = exprFactory.regex((Object)exprFactory.str(QUESTION_MARK.concat(LABEL)), targetResourceLabel, EMPTY);
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar(QUESTION_MARK.concat(QUERY_ENDPOINT)).addVar(QUESTION_MARK.concat(UPDATE_ENDPOINT)).addWhere(QUESTION_MARK.concat(RESOURCE), RDF_PREFIX.concat(COLON).concat(RDF_TYPE), ONTOKGROUTER_PREFIX.concat(COLON).concat(TARGET_RESOURCE)).addOptional(QUESTION_MARK.concat(RESOURCE), ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_QUERY_ENDPOINT), QUESTION_MARK.concat(QUERY_ENDPOINT)).addOptional(QUESTION_MARK.concat(RESOURCE), ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_UPDATE_ENDPOINT), QUESTION_MARK.concat(UPDATE_ENDPOINT)).addWhere(QUESTION_MARK.concat(RESOURCE), RDFS_PREFIX.concat(COLON).concat(LABEL), QUESTION_MARK.concat(LABEL)).addFilter(exprRegex);
        JSONArray results = storeClient.executeQuery(builder.toString());
        if (!results.isEmpty()) {
            JSONObject obj = results.getJSONObject(0);
            String queryEndpoint = MiscUtil.optNullKey(obj, QUERY_ENDPOINT);
            String updateEndpoint = MiscUtil.optNullKey(obj, UPDATE_ENDPOINT);
            ArrayList<String> endpoints = new ArrayList<String>();
            endpoints.add(0, queryEndpoint);
            endpoints.add(1, updateEndpoint);
            return endpoints;
        }
        LOGGER.error("Endpoints not found for resource=" + targetResourceLabel);
        return null;
    }

    public static boolean isRemoteTargetResourceID(String targetResourceID) {
        if (InputValidator.checkIfValidIRI(targetResourceID)) {
            return true;
        }
        if (targetResourceID.matches("[A-Za-z0-9\\-\\_]+")) {
            return true;
        }
        LOGGER.error("Invalid namespace label:" + targetResourceID + ". Not alphanumeric (special characters - and _ are allowed).");
        return false;
    }

    public static boolean isFileBasedTargetResourceID(String targetResourceID) {
        if (FILE_EXTENSIONS.stream().anyMatch(targetResourceID.trim()::endsWith)) {
            String path = null;
            try {
                path = InputValidator.checkIfValidIRI(targetResourceID) ? StoreRouter.getPathComponent(targetResourceID) : targetResourceID;
                Paths.get(path, new String[0]);
            }
            catch (InvalidPathException | JPSRuntimeException ex) {
                LOGGER.error("Invalid file path: " + path);
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getLabelFromTargetResourceID(String targetResourceID) {
        return targetResourceID.substring(targetResourceID.lastIndexOf(SLASH) + 1).trim();
    }

    public static String getPathComponent(String iri) {
        String path = null;
        try {
            URI uri = new URI(URLDecoder.decode(iri.trim(), "UTF-8"));
            path = uri.getPath();
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new JPSRuntimeException(e);
        }
        return path;
    }

    public static String joinPaths(String path1, String path2) {
        if (!path2.startsWith(SLASH)) {
            return path1.trim() + SLASH + path2.trim();
        }
        return path1.trim() + path2.trim();
    }

    private String getLocalFilePath(String targetResourceName, TripleStoreClientInterface storeClient) {
        ExprFactory exprFactory = new ExprFactory();
        E_Regex exprRegex = exprFactory.regex((Object)exprFactory.str(QUESTION_MARK.concat(LABEL)), targetResourceName, EMPTY);
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar(QUESTION_MARK.concat(FILE_PATH)).addWhere(QUESTION_MARK.concat(RESOURCE), RDF_PREFIX.concat(COLON).concat(RDF_TYPE), ONTOKGROUTER_PREFIX.concat(COLON).concat(TARGET_RESOURCE)).addWhere(QUESTION_MARK.concat(RESOURCE), ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_FILE_PATH), QUESTION_MARK.concat(FILE_PATH)).addWhere(QUESTION_MARK.concat(RESOURCE), RDFS_PREFIX.concat(COLON).concat(LABEL), QUESTION_MARK.concat(LABEL)).addFilter(exprRegex);
        JSONArray jsonArray = storeClient.executeQuery(builder.toString());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(FILE_PATH));
            return obj.getString(FILE_PATH);
        }
        return null;
    }

    static {
        if (storeRouterEndpoint == null) {
            LOGGER.info("STOREROUTER_ENDPOINT not found in environment variables... Using jps.properties.");
            storeRouterEndpoint = KeyValueMap.getInstance().get("url.storerouter.endpoint");
        }
        LOGGER.info("STOREROUTER_ENDPOINT set to " + storeRouterEndpoint);
        CACHE_SIZE = Integer.parseInt(KeyValueMap.getInstance().get("storerouter.cache.size"));
        storeRouter = null;
    }
}

