/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.jdbc.remote.RemoteEndpointDriver;
import org.apache.jena.query.Query;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.federated.FedXFactory;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.util.StoreClientHelper;

public class RemoteStoreClient
implements TripleStoreClientInterface {
    private static final Logger LOGGER = LogManager.getLogger(RemoteStoreClient.class);
    private static final String HTTP_PROTOCOL = "http:";
    private static final String HTTPS_PROTOCOL = "https:";
    Connection conn;
    Statement stmt;
    private String queryEndpoint;
    private String updateEndpoint;
    private String query;
    private String userName;
    private String password;

    public RemoteStoreClient() {
    }

    public RemoteStoreClient(String queryEndpoint) {
        this.queryEndpoint = queryEndpoint;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint) {
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
    }

    public RemoteStoreClient(String queryEndpoint, String user, String password) {
        this.queryEndpoint = queryEndpoint;
        this.userName = user;
        this.password = password;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint, String user, String password) {
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.userName = user;
        this.password = password;
    }

    public RemoteStoreClient(String queryEndpoint, String updateEndpoint, String query, String user, String password) {
        this.query = query;
        this.queryEndpoint = queryEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.userName = user;
        this.password = password;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return this.query;
    }

    @Override
    public String getQueryEndpoint() {
        return this.queryEndpoint;
    }

    @Override
    public String setQueryEndpoint(String queryEndpoint) {
        this.queryEndpoint = queryEndpoint;
        return this.queryEndpoint;
    }

    @Override
    public String getUpdateEndpoint() {
        return this.updateEndpoint;
    }

    @Override
    public String setUpdateEndpoint(String updateEndpoint) {
        this.updateEndpoint = updateEndpoint;
        return this.updateEndpoint;
    }

    @Override
    public String getUser() {
        return this.userName;
    }

    @Override
    public void setUser(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUpdateEndpointBlazegraphBackended() {
        if (!Objects.isNull(this.getUpdateEndpoint())) {
            try {
                if (new URI(this.getUpdateEndpoint().toLowerCase()).normalize().getPath().toString().contains("/blazegraph/namespace/")) {
                    return true;
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public int executeUpdate() {
        return this.executeUpdate(this.query);
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        return this.executeUpdate(update.toString());
    }

    @Override
    public int executeUpdate(String query) {
        try {
            String connectionUrl = this.getConnectionUrl();
            if (connectionUrl.isEmpty()) {
                throw new JPSRuntimeException("RemoteStoreClient: connection URL for the update operation is empty.");
            }
            if (this.isConnectionUpdateUrlValid(connectionUrl)) {
                this.connect(connectionUrl);
                return this.stmt.executeUpdate(query);
            }
            throw new JPSRuntimeException("RemoteStoreClient: connection URL for the update operation is not valid.");
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public HttpResponse executeUpdateByPost(String query) {
        StringEntity entity = new StringEntity(query, ContentType.create("application/sparql-update"));
        HttpPost postRequest = new HttpPost(this.updateEndpoint);
        if (this.userName != null && this.password != null) {
            String auth = this.userName + ":" + this.password;
            String encoded_auth = Base64.getEncoder().encodeToString(auth.getBytes());
            postRequest.setHeader("Authorization", "Basic " + encoded_auth);
        }
        postRequest.setEntity(entity);
        LOGGER.info("Executing SPARQL update to " + this.updateEndpoint + ". SPARQL update string: " + query);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpclient.execute(postRequest);
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 300) {
                throw new JPSRuntimeException("SPARQL update execution by HTTP POST failed. Response status code =" + response.getStatusLine().getStatusCode());
            }
            return response;
        }
        catch (IOException ex) {
            throw new JPSRuntimeException("SPARQL update execution by HTTP POST failed.", ex);
        }
    }

    @Override
    public String execute() {
        return this.execute(this.query);
    }

    @Override
    public String execute(String query) {
        JSONArray result = this.executeQuery(query);
        if (result == null) {
            throw new JPSRuntimeException("RemoteStoreClient: sparql query result is null.");
        }
        return result.toString();
    }

    @Override
    public JSONArray executeQuery() {
        return this.executeQuery(this.query);
    }

    @Override
    public JSONArray executeQuery(String query) {
        JSONArray results;
        block11: {
            try {
                String connectionUrl = this.getConnectionUrl();
                if (connectionUrl.isEmpty()) {
                    throw new JPSRuntimeException("RemoteStoreClient: the URL to connect to the endpoint is empty");
                }
                if (this.isConnectionQueryUrlValid(connectionUrl)) {
                    this.connect(connectionUrl);
                    ResultSet rs = this.stmt.executeQuery(query);
                    results = StoreClientHelper.convert(rs);
                    break block11;
                }
                throw new JPSRuntimeException("RemoteStoreClient: the URL to connect to the endpoint is not valid");
            }
            catch (SQLException e) {
                throw new JPSRuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(e.getMessage(), e);
                }
            }
        }
        return results;
    }

    @Override
    public Model executeConstruct(Query sparql) {
        return this.executeConstruct(sparql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model executeConstruct(String sparql) {
        RDFConnection conn = this.connectQuery();
        if (conn != null) {
            conn.begin(TxnType.READ);
            try {
                Model model = conn.queryConstruct(sparql);
                return model;
            }
            finally {
                conn.end();
            }
        }
        throw new JPSRuntimeException("RemoteStoreClient: client not initialised.");
    }

    private RDFConnection connectQuery() {
        RDFConnectionRemoteBuilder builder = null;
        if (this.queryEndpoint == null) {
            throw new JPSRuntimeException("RemoteStoreClient: update endpoint not specified.");
        }
        builder = RDFConnectionRemote.create().destination(this.queryEndpoint);
        return builder.build();
    }

    protected void connect(String connectionUrl) {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                RemoteEndpointDriver.register();
                this.conn = DriverManager.getConnection(connectionUrl);
                this.stmt = this.conn.createStatement(1003, 1007);
            }
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder();
        boolean queryFlag = false;
        boolean updateFlag = false;
        sb.append("jdbc:jena:");
        sb.append("remote:");
        if (this.queryEndpoint != null) {
            queryFlag = true;
            sb.append(this.generateEndpointProperty("query", this.queryEndpoint));
        }
        if (this.updateEndpoint != null) {
            updateFlag = true;
            if (queryFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("update", this.updateEndpoint));
        }
        if (this.userName != null) {
            if (queryFlag || updateFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("user", this.userName));
        }
        if (this.password != null) {
            if (queryFlag || updateFlag) {
                sb.append("&");
            }
            sb.append(this.generateEndpointProperty("password", this.password));
        }
        return sb.toString();
    }

    private String generateEndpointProperty(String endpointType, String endpointURL) {
        StringBuilder sb = new StringBuilder();
        sb.append(endpointType);
        sb.append("=");
        sb.append(endpointURL);
        return sb.toString();
    }

    public boolean isConnectionQueryUrlValid(String connectionUrl) {
        if (connectionUrl.startsWith(this.getQueryEndpointConnectionPrfixes().concat(HTTP_PROTOCOL)) || connectionUrl.startsWith(this.getQueryEndpointConnectionPrfixes().concat(HTTPS_PROTOCOL))) {
            return this.isConnectionUrlValid(connectionUrl);
        }
        return false;
    }

    public boolean isConnectionUpdateUrlValid(String connectionUrl) {
        if (this.isConnectionQueryUrlValid(connectionUrl) && (connectionUrl.contains(this.getUpdateEndpointConnectionParameter().concat(HTTP_PROTOCOL)) || connectionUrl.contains(this.getUpdateEndpointConnectionParameter().concat(HTTPS_PROTOCOL)))) {
            return true;
        }
        if (connectionUrl.startsWith(this.getUpdateEndpointConnectionPrefixes().concat(HTTP_PROTOCOL)) || connectionUrl.startsWith(this.getUpdateEndpointConnectionPrefixes().concat(HTTPS_PROTOCOL))) {
            return this.isConnectionUrlValid(connectionUrl);
        }
        return false;
    }

    private boolean isConnectionUrlValid(String connectionUrl) {
        String[] tokens = new String[]{""};
        if (connectionUrl.contains(HTTP_PROTOCOL)) {
            tokens = connectionUrl.split(HTTP_PROTOCOL);
        } else if (connectionUrl.contains(HTTPS_PROTOCOL)) {
            tokens = connectionUrl.split(HTTPS_PROTOCOL);
        }
        for (String token : tokens) {
            if (token.isEmpty()) {
                return false;
            }
            if (token.length() >= 3) continue;
            return false;
        }
        return true;
    }

    private String getQueryEndpointConnectionPrfixes() {
        return "jdbc:jena:".concat("remote:").concat("query").concat("=");
    }

    private String getUpdateEndpointConnectionPrefixes() {
        return "jdbc:jena:".concat("remote:").concat("update").concat("=");
    }

    private String getUpdateEndpointConnectionParameter() {
        return "update".concat("=");
    }

    public JSONArray executeFederatedQuery(List<String> endpoints, String query) throws Exception {
        JSONArray json = new JSONArray();
        FedXRepository repository = FedXFactory.createSparqlFederation(endpoints);
        try {
            RepositoryConnection conn = repository.getConnection();
            TupleQuery tq = conn.prepareTupleQuery(query);
            try {
                TupleQueryResult tqRes = tq.evaluate();
                while (tqRes.hasNext()) {
                    JSONObject obj = new JSONObject();
                    BindingSet bSet = (BindingSet)tqRes.next();
                    for (String bindingName : bSet.getBindingNames()) {
                        if (bSet.getValue(bindingName).toString().startsWith("\"") && bSet.getValue(bindingName).toString().endsWith("\"")) {
                            obj.put(bindingName, bSet.getValue(bindingName).toString().substring(1, bSet.getValue(bindingName).toString().length() - 1));
                            continue;
                        }
                        obj.put(bindingName, bSet.getValue(bindingName).toString());
                    }
                    json.put(obj);
                }
            }
            catch (TupleQueryResultHandlerException e) {
                e.printStackTrace();
            }
            conn.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        repository.shutDown();
        return json;
    }

    @Override
    public String get(String resourceUrl, String accept) {
        Var varS = Var.alloc("s");
        Var varP = Var.alloc("p");
        Var varO = Var.alloc("o");
        ConstructBuilder builder = new ConstructBuilder().addConstruct(varS, varP, varO);
        if (resourceUrl == null) {
            builder.addWhere(varS, varP, varO);
        } else {
            String graphURI = "<" + resourceUrl + ">";
            builder.addGraph(graphURI, varS, varP, varO);
        }
        Model model = this.executeConstruct(builder.build());
        Lang syntax = accept != null ? RDFLanguages.contentTypeToLang(accept) : Lang.RDFXML;
        StringWriter out = new StringWriter();
        model.write(out, syntax.getName());
        return out.toString();
    }

    @Override
    public void insert(String graphName, String content, String contentType) {
        Model model = ModelFactory.createDefaultModel();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        if (contentType == null) {
            model.read(in, null);
        } else {
            Lang syntax = RDFLanguages.contentTypeToLang(contentType);
            model.read(in, null, syntax.getName());
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (graphName == null) {
            builder.addInsert(model);
        } else {
            String graphURI = "<" + graphName + ">";
            builder.addInsert((Object)graphURI, model);
        }
        this.executeUpdate(builder.buildRequest());
    }

    public void uploadFile(File file) {
        String extension = FilenameUtils.getExtension(file.getAbsolutePath());
        this.uploadFile(file, extension);
    }

    public void uploadFile(File file, String extension) {
        FileEntity entity;
        if (!file.exists()) {
            throw new JPSRuntimeException("Provided file does not exist " + file.getAbsolutePath());
        }
        switch (extension) {
            case "rdf": 
            case "rdfs": 
            case "owl": 
            case "xml": {
                entity = new FileEntity(file, ContentType.create("application/rdf+xml"));
                break;
            }
            case "nt": {
                entity = new FileEntity(file, ContentType.TEXT_PLAIN);
                break;
            }
            case "ntx": {
                entity = new FileEntity(file, ContentType.create("application/x-n-triples-RDR"));
                break;
            }
            case "ttl": {
                entity = new FileEntity(file, ContentType.create("application/x-turtle"));
                break;
            }
            case "ttlx": {
                entity = new FileEntity(file, ContentType.create("application/x-turtle-RDR"));
                break;
            }
            case "n3": {
                entity = new FileEntity(file, ContentType.create("text/rdf+n3"));
                break;
            }
            case "trix": {
                entity = new FileEntity(file, ContentType.create("application/trix"));
                break;
            }
            case "trig": {
                entity = new FileEntity(file, ContentType.create("application/x-trig"));
                break;
            }
            case "nq": {
                entity = new FileEntity(file, ContentType.create("text/x-nquads"));
                break;
            }
            case "srj": {
                entity = new FileEntity(file, ContentType.create("application/sparql-results+json"));
                break;
            }
            case "json": {
                entity = new FileEntity(file, ContentType.APPLICATION_JSON);
                break;
            }
            default: {
                throw new JPSRuntimeException("Unsupported file extension: " + extension);
            }
        }
        HttpPost postRequest = new HttpPost(this.updateEndpoint);
        if (this.userName != null && this.password != null) {
            String auth = this.userName + ":" + this.password;
            String encoded_auth = Base64.getEncoder().encodeToString(auth.getBytes());
            postRequest.setHeader("Authorization", "Basic " + encoded_auth);
        }
        postRequest.setEntity(entity);
        LOGGER.info("Uploading " + file + " to " + this.updateEndpoint);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpclient.execute(postRequest);
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 300) {
                throw new JPSRuntimeException("Upload RDF file failed. Response status code =" + response.getStatusLine().getStatusCode());
            }
        }
        catch (IOException ex) {
            throw new JPSRuntimeException("Upload RDF file failed.", ex);
        }
    }
}

