/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jena.update.UpdateRequest;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.util.StoreClientHelper;

public class RemoteRDBStoreClient
implements StoreClientInterface {
    private Connection conn;
    Statement stmt;
    private String rdbURL;
    private String rdbUser;
    private String rdbPassword;
    private String query;
    static final String driver = "org.postgresql.Driver";

    public RemoteRDBStoreClient(String rdbURL, String user, String password) {
        this.rdbURL = rdbURL;
        this.rdbUser = user;
        this.rdbPassword = password;
    }

    public RemoteRDBStoreClient(String rdbURL, String user, String password, String query) {
        this.rdbURL = rdbURL;
        this.rdbUser = user;
        this.rdbPassword = password;
        this.query = query;
    }

    public Connection getConnection() {
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(this.rdbURL, this.rdbUser, this.rdbPassword);
            this.stmt = this.conn.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException("The connection attempt failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new JPSRuntimeException("Failed to load postgresql", e);
        }
        return this.conn;
    }

    public ResultSet executeQuerytoResultSet(String query) {
        ResultSet rs;
        try {
            if (this.conn == null || this.stmt == null) {
                this.conn = this.getConnection();
            }
            rs = this.stmt.executeQuery(query);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return rs;
    }

    @Override
    public JSONArray executeQuery(String query) {
        JSONArray results;
        try {
            if (this.conn == null || this.stmt == null) {
                this.conn = this.getConnection();
            }
            ResultSet rs = this.stmt.executeQuery(query);
            results = StoreClientHelper.convert(rs);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return results;
    }

    @Override
    public JSONArray executeQuery() {
        return this.executeQuery(this.query);
    }

    @Override
    public String execute() {
        return this.execute(this.query);
    }

    @Override
    public String execute(String query) {
        JSONArray result = this.executeQuery(query);
        if (result == null) {
            throw new JPSRuntimeException("Query result is null.");
        }
        return result.toString();
    }

    @Override
    public int executeUpdate(String update) {
        try {
            if (this.conn == null || this.stmt == null) {
                this.conn = this.getConnection();
            }
            return this.stmt.executeUpdate(update);
        }
        catch (SQLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        return this.executeUpdate(update.toString());
    }

    @Override
    public int executeUpdate() {
        return this.executeUpdate(this.query);
    }

    public void setRdbURL(String rdbURL) {
        this.rdbURL = rdbURL;
    }

    public String getRdbURL() {
        return this.rdbURL;
    }

    @Override
    public void setUser(String user) {
        this.rdbUser = user;
    }

    @Override
    public String getUser() {
        return this.rdbUser;
    }

    @Override
    public void setPassword(String password) {
        this.rdbPassword = password;
    }

    @Override
    public String getPassword() {
        return this.rdbPassword;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return this.query;
    }
}

