/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class RowIsNull
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Set<SQLDialect> EMULATE_NULL_ROW = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> EMULATE_NULL_QUERY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Row row;
    private final Select<?> select;
    private final boolean isNull;

    RowIsNull(Row row, boolean isNull) {
        this.row = row;
        this.select = null;
        this.isNull = isNull;
    }

    RowIsNull(Select<?> select, boolean isNull) {
        this.row = null;
        this.select = select;
        this.isNull = isNull;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.row != null && EMULATE_NULL_ROW.contains((Object)ctx.dialect())) {
            ctx.visit(this.condition(this.row.fields()));
        } else if (this.select != null && EMULATE_NULL_QUERY.contains((Object)ctx.dialect())) {
            if (this.select.getSelect().size() == 1) {
                this.acceptStandard(ctx);
            } else {
                Table t = new AliasedSelect(this.select).as("t");
                ctx.visit(DSL.inline(1).eq(DSL.selectCount().from((TableLike<?>)t).where(this.condition(t.fields()))));
            }
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final Condition condition(Field<?>[] fields) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(fields.length);
        for (Field<?> field : fields) {
            conditions.add(this.isNull ? field.isNull() : field.isNotNull());
        }
        return DSL.and(conditions);
    }

    private final void acceptStandard(Context<?> ctx) {
        if (this.row != null) {
            ctx.visit(this.row);
        } else {
            Tools.visitSubquery(ctx, this.select, true);
        }
        ctx.sql(' ').visit(this.isNull ? Keywords.K_IS_NULL : Keywords.K_IS_NOT_NULL);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

