/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jooq.Cursor;
import org.jooq.Record;
import org.jooq.impl.AbstractResultQuery;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.Internal;
import org.jooq.impl.Tools;
import org.jooq.tools.jdbc.JDBCUtils;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class R2DBC {
    R2DBC() {
    }

    static final class BlockingRowCountSubscription
    extends AbstractSubscription<Integer> {
        final AbstractRowCountQuery query;

        BlockingRowCountSubscription(AbstractRowCountQuery query, Subscriber<? super Integer> subscriber) {
            super(subscriber);
            this.query = query;
        }

        @Override
        final void request0() {
            try {
                this.subscriber.onNext((Object)this.query.execute());
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
            }
        }

        @Override
        final void cancel0() {
        }
    }

    static final class BlockingRecordSubscription<R extends Record>
    extends AbstractSubscription<R> {
        private final AbstractResultQuery<R> query;
        private volatile Cursor<R> c;

        BlockingRecordSubscription(AbstractResultQuery<R> query, Subscriber<? super R> subscriber) {
            super(subscriber);
            this.query = query;
        }

        @Override
        final synchronized void request0() {
            try {
                if (this.c == null) {
                    this.c = this.query.fetchLazyNonAutoClosing();
                }
                while (this.requested.getAndUpdate(l -> Math.max(0L, l - 1L)) > 0L) {
                    R r = this.c.fetchNext();
                    if (r == null) {
                        this.subscriber.onComplete();
                        JDBCUtils.safeClose(this.c);
                        break;
                    }
                    this.subscriber.onNext(r);
                }
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
                JDBCUtils.safeClose(this.c);
            }
        }

        @Override
        final void cancel0() {
            JDBCUtils.safeClose(this.c);
        }
    }

    static abstract class AbstractSubscription<T>
    implements Subscription {
        final AtomicBoolean completed = new AtomicBoolean();
        final AtomicLong requested = new AtomicLong();
        final Subscriber<? super T> subscriber;
        final Tools.ThreadGuard.Guard guard = new Tools.ThreadGuard.Guard();

        AbstractSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = Internal.subscriber(arg_0 -> subscriber.onSubscribe(arg_0), arg_0 -> subscriber.onNext(arg_0), arg_0 -> subscriber.onError(arg_0), () -> {
                this.completed.set(true);
                subscriber.onComplete();
            });
        }

        public final void request(long n) {
            if (n <= 0L) {
                this.subscriber.onError((Throwable)new IllegalArgumentException("Rule 3.9 non-positive request signals are illegal"));
            } else if (!this.completed.get()) {
                this.requested.accumulateAndGet(n, (x, y) -> {
                    long r = x + y;
                    if (((x ^ r) & (y ^ r)) < 0L) {
                        return Long.MAX_VALUE;
                    }
                    return r;
                });
                Tools.ThreadGuard.run(this.guard, this::request0, () -> {});
            }
        }

        public final void cancel() {
            if (!this.completed.getAndSet(true)) {
                this.cancel0();
            }
        }

        abstract void request0();

        abstract void cancel0();
    }
}

