/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.ConnectionCallable;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKey;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

final class MetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 3582980783173033809L;
    private static final JooqLogger log = JooqLogger.getLogger(MetaImpl.class);
    private static final Set<SQLDialect> INVERSE_SCHEMA_CATALOG = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> CURRENT_TIMESTAMP_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> EXPRESSION_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.H2);
    private final DatabaseMetaData databaseMetaData;
    private final boolean inverseSchemaCatalog;
    private static final Class<?>[] GET_COLUMNS_SHORT = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class};
    private static final Class<?>[] GET_COLUMNS_EXTENDED = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class};

    MetaImpl(Configuration configuration, DatabaseMetaData databaseMetaData) {
        super(configuration);
        this.databaseMetaData = databaseMetaData;
        this.inverseSchemaCatalog = INVERSE_SCHEMA_CATALOG.contains((Object)this.dialect());
    }

    private final Result<Record> meta(final MetaFunction consumer) {
        if (this.databaseMetaData == null) {
            return this.dsl().connectionResult(new ConnectionCallable<Result<Record>>(){

                @Override
                public Result<Record> run(Connection connection) throws SQLException {
                    return consumer.run(connection.getMetaData());
                }
            });
        }
        try {
            return consumer.run(this.databaseMetaData);
        }
        catch (SQLException e) {
            throw new DataAccessException("Error while running MetaFunction", e);
        }
    }

    @Override
    final List<Catalog> getCatalogs0() {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        if (result.isEmpty()) {
            result.add(new MetaCatalog(""));
        }
        return result;
    }

    final Table<?> lookupTable(Schema schema, String tableName) {
        switch (this.family()) {
            case SQLITE: {
                return AbstractNamed.findIgnoreCase(tableName, schema.getTables());
            }
        }
        return schema.getTable(tableName);
    }

    @Override
    final List<Schema> getSchemas0() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.getCatalogs()) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    final List<Table<?>> getTables0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    final List<Sequence<?>> getSequences0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getSequences());
        }
        return result;
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            UniqueKey<?> pk = table.getPrimaryKey();
            if (pk == null) continue;
            result.add(pk);
        }
        return result;
    }

    @Override
    public String toString() {
        return "MetaImpl";
    }

    private final class MetaPrimaryKey
    extends AbstractKey<Record>
    implements UniqueKey<Record> {
        private static final long serialVersionUID = 6997258619475953490L;

        MetaPrimaryKey(Table<Record> table, String pkName, TableField<Record, ?>[] fields) {
            super(table, pkName == null ? null : DSL.name(pkName), fields, true);
        }

        @Override
        public final boolean isPrimary() {
            return true;
        }

        @Override
        public final List<ForeignKey<?, Record>> getReferences() {
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    String schema = MetaPrimaryKey.this.getTable().getSchema().getName();
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getExportedKeys(schema, null, MetaPrimaryKey.this.getName()) : meta.getExportedKeys(null, schema, MetaPrimaryKey.this.getName());
                    return MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                }
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 5 : 4), result.field(MetaImpl.this.inverseSchemaCatalog ? 4 : 5), result.field(6), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            ArrayList references = new ArrayList(groups.size());
            for (Map.Entry entry : groups.entrySet()) {
                Record key = entry.getKey();
                Result value = entry.getValue();
                Schema schema = (Schema)schemas.get(StringUtils.defaultString(key.get(1, String.class)));
                Table<?> fkTable = MetaImpl.this.lookupTable(schema, key.get(2, String.class));
                String fkName = key.get(3, String.class);
                TableField[] fkFields = new TableField[value.size()];
                TableField[] pkFields = new TableField[value.size()];
                for (int i = 0; i < value.size(); ++i) {
                    pkFields[i] = (TableField)this.getTable().field(((Record)value.get(i)).get(3, String.class));
                    fkFields[i] = (TableField)fkTable.field(((Record)value.get(i)).get(7, String.class));
                }
                references.add(new ReferenceImpl(fkTable, DSL.name(fkName), fkFields, this, pkFields, true));
            }
            return references;
        }

        @Override
        final ConstraintEnforcementStep constraint0() {
            if (this.isPrimary()) {
                return DSL.constraint(this.getName()).primaryKey(this.getFieldsArray());
            }
            return DSL.constraint(this.getName()).unique(this.getFieldsArray());
        }
    }

    private final class MetaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4843841667753000233L;

        MetaTable(String name, Schema schema, Result<Record> columns, TableOptions.TableType tableType) {
            super(DSL.name(name), schema, null, null, null, null, null, TableOptions.of(tableType));
            if (columns != null) {
                this.init(columns);
            }
        }

        @Override
        public final List<Index> getIndexes() {
            final String schema = this.getSchema() == null ? null : this.getSchema().getName();
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getIndexInfo(schema, null, MetaTable.this.getName(), false, true) : meta.getIndexInfo(null, schema, MetaTable.this.getName(), false, true);
                    return MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, String.class);
                }
            });
            result.sortAsc(7).sortAsc(5);
            return this.createIndexes(result);
        }

        @Override
        public final List<UniqueKey<Record>> getKeys() {
            UniqueKey<Record> pk = this.getPrimaryKey();
            return pk == null ? Collections.emptyList() : Collections.singletonList(pk);
        }

        @Override
        public final UniqueKey<Record> getPrimaryKey() {
            final String schema = this.getSchema() == null ? null : this.getSchema().getName();
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getPrimaryKeys(schema, null, MetaTable.this.getName()) : meta.getPrimaryKeys(null, schema, MetaTable.this.getName());
                    return MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class);
                }
            });
            result.sortAsc(4);
            return this.createPrimaryKey(result, 3);
        }

        @Override
        public List<ForeignKey<Record, ?>> getReferences() {
            Result result = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    String schema = MetaTable.this.getSchema().getName();
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getImportedKeys(schema, null, MetaTable.this.getName()) : meta.getImportedKeys(null, schema, MetaTable.this.getName());
                    return MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                }
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 1 : 0), result.field(MetaImpl.this.inverseSchemaCatalog ? 0 : 1), result.field(2), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            ArrayList references = new ArrayList(groups.size());
            for (Map.Entry entry : groups.entrySet()) {
                Schema schema = (Schema)schemas.get(StringUtils.defaultString(entry.getKey().get(1, String.class)));
                String fkName = entry.getKey().get(3, String.class);
                String pkName = entry.getKey().get(4, String.class);
                Table<Record> pkTable = MetaImpl.this.lookupTable(schema, entry.getKey().get(2, String.class));
                TableField[] pkFields = new TableField[entry.getValue().size()];
                TableField[] fkFields = new TableField[entry.getValue().size()];
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    Record record = (Record)entry.getValue().get(i);
                    pkFields[i] = (TableField)pkTable.field(record.get(3, String.class));
                    fkFields[i] = (TableField)this.field(record.get(7, String.class));
                }
                references.add(new ReferenceImpl<Record, Record>(this, DSL.name(fkName), fkFields, new MetaPrimaryKey(pkTable, pkName, pkFields), pkFields, true));
            }
            return references;
        }

        private final UniqueKey<Record> createPrimaryKey(Result<Record> result, int columnName) {
            if (result.size() > 0) {
                TableField[] f = new TableField[result.size()];
                for (int i = 0; i < f.length; ++i) {
                    String name = ((Record)result.get(i)).get(columnName, String.class);
                    f[i] = (TableField)this.field(name);
                    if (f[i] != null || MetaImpl.this.family() != SQLDialect.SQLITE) continue;
                    for (Field<?> field : this.fields()) {
                        if (!field.getName().equalsIgnoreCase(name)) continue;
                        f[i] = (TableField)field;
                    }
                }
                String indexName = ((Record)result.get(0)).get(5, String.class);
                return new MetaPrimaryKey(this, indexName, f);
            }
            return null;
        }

        private final List<Index> createIndexes(Result<Record> result) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            ArrayList<SortField<Object>> sortFields = new ArrayList<SortField<Object>>();
            String previousIndexName = null;
            Name name = null;
            Condition where = null;
            boolean unique = false;
            for (int i = 0; i < result.size(); ++i) {
                boolean desc;
                String columnName;
                Field<Object> field;
                Record record = (Record)result.get(i);
                String indexName = record.get(5, String.class);
                if (indexName == null) continue;
                if (!indexName.equals(previousIndexName)) {
                    previousIndexName = indexName;
                    sortFields.clear();
                    name = DSL.name(record.get(0, String.class), record.get(1, String.class), indexName);
                    String filter = record.get(12, String.class);
                    where = !StringUtils.isBlank(filter) ? DSL.condition(filter) : null;
                    boolean bl = unique = record.get(3, Boolean.TYPE) == false;
                }
                if ((field = this.field(columnName = record.get(8, String.class))) == null) {
                    field = DSL.field(columnName);
                }
                sortFields.add((desc = "D".equalsIgnoreCase(record.get(9, String.class))) ? field.desc() : field.asc());
                if (i + 1 != result.size() && ((Record)result.get(i + 1)).get(5, String.class).equals(previousIndexName)) continue;
                indexes.add(new IndexImpl(name, this, (OrderField[])sortFields.toArray(Tools.EMPTY_SORTFIELD), where, unique));
            }
            return indexes;
        }

        private final void init(Result<Record> columns) {
            boolean hasAutoIncrement = false;
            for (Record column : columns) {
                DataType<Object> type;
                String remarks;
                String columnName;
                block11: {
                    columnName = column.get(3, String.class);
                    String typeName = column.get(5, String.class);
                    int precision = column.get(6, Integer.TYPE);
                    int scale = column.get(8, Integer.TYPE);
                    int nullable = column.get(10, Integer.TYPE);
                    remarks = column.get(11, String.class);
                    String defaultValue = column.get(12, String.class);
                    boolean isAutoIncrement = column.size() >= 23 ? column.get(22, Boolean.TYPE) : false;
                    type = null;
                    try {
                        type = DefaultDataType.getDataType(MetaImpl.this.family(), typeName, precision, scale, !Boolean.FALSE.equals(MetaImpl.this.settings().isForceIntegerTypesOnZeroScaleDecimals()));
                        if (isAutoIncrement) {
                            if (!hasAutoIncrement) {
                                hasAutoIncrement = isAutoIncrement;
                                type = type.identity(hasAutoIncrement);
                            } else {
                                log.info((Object)"Multiple identities", "jOOQ does not support tables with multiple identities. Identity is ignored on column: " + columnName);
                            }
                        }
                        if (nullable == 0) {
                            type = type.nullable(false);
                        }
                        if (isAutoIncrement || StringUtils.isEmpty(defaultValue)) break block11;
                        try {
                            if (EXPRESSION_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect())) {
                                type = type.defaultValue(DSL.field(defaultValue, type));
                                break block11;
                            }
                            if (CURRENT_TIMESTAMP_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect()) && "CURRENT_TIMESTAMP".equalsIgnoreCase(defaultValue)) {
                                type = type.defaultValue(DSL.field(defaultValue, type));
                                break block11;
                            }
                            type = type.defaultValue(DSL.inline((Object)defaultValue, type));
                        }
                        catch (DataTypeException e) {
                            log.warn("Default value", "Could not load default value: " + defaultValue + " for type: " + type, e);
                        }
                    }
                    catch (SQLDialectNotSupportedException e) {
                        type = SQLDataType.OTHER;
                    }
                }
                MetaTable.createField(DSL.name(columnName), type, this, remarks);
            }
        }
    }

    private final class MetaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -2621899850912554198L;
        private volatile transient Map<Name, Result<Record>> columnCache;

        MetaSchema(String name, Catalog catalog) {
            super(name, catalog);
        }

        @Override
        public final synchronized List<Table<?>> getTables() {
            Result tables = MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    String[] types = null;
                    switch (MetaImpl.this.family()) {
                        case POSTGRES: {
                            types = new String[]{"FOREIGN TABLE", "MATERIALIZED VIEW", "SYSTEM_TABLE", "SYSTEM_VIEW", "TABLE", "VIEW"};
                            break;
                        }
                        case SQLITE: {
                            types = new String[]{"TABLE", "VIEW"};
                        }
                    }
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getTables(MetaSchema.this.getName(), null, "%", types) : meta.getTables(null, MetaSchema.this.getName(), "%", types);
                    return MetaImpl.this.dsl().fetch(rs, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR);
                }
            });
            ArrayList result = new ArrayList(tables.size());
            for (Record table : tables) {
                String catalog = table.get(0, String.class);
                String schema = table.get(1, String.class);
                String name = table.get(2, String.class);
                String type = table.get(3, String.class);
                TableOptions.TableType tableType = "VIEW".equals(type) ? TableOptions.TableType.VIEW : ("SYSTEM_VIEW".equals(type) ? TableOptions.TableType.VIEW : ("GLOBAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("LOCAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("MATERIALIZED VIEW".equals(type) ? TableOptions.TableType.MATERIALIZED_VIEW : TableOptions.TableType.TABLE)))));
                result.add(new MetaTable(name, this, this.getColumns(catalog, schema, name), tableType));
            }
            return result;
        }

        private final Result<Record> getColumns(String catalog, String schema, String table) {
            if (this.columnCache == null && MetaImpl.this.family() != SQLDialect.SQLITE) {
                Result<Record> columns = this.getColumns0(catalog, schema, "%");
                Field<?> tableCat = columns.field(0);
                Field<?> tableSchem = columns.field(1);
                Field<?> tableName = columns.field(2);
                Map<Record, Result<Record>> groups = columns.intoGroups(new Field[]{tableCat, tableSchem, tableName});
                this.columnCache = new LinkedHashMap<Name, Result<Record>>();
                for (Map.Entry<Record, Result<Record>> entry : groups.entrySet()) {
                    Record key = entry.getKey();
                    Result<Record> value = entry.getValue();
                    this.columnCache.put(DSL.name((String)key.get(tableCat), (String)key.get(tableSchem), (String)key.get(tableName)), value);
                }
            }
            if (this.columnCache != null) {
                return this.columnCache.get(DSL.name(catalog, schema, table));
            }
            return this.getColumns0(catalog, schema, table);
        }

        private final Result<Record> getColumns0(final String catalog, final String schema, final String table) {
            return MetaImpl.this.meta(new MetaFunction(){

                @Override
                public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                    ResultSet rs = MetaImpl.this.inverseSchemaCatalog ? meta.getColumns(catalog, null, table, "%") : meta.getColumns(null, schema, table, "%");
                    return rs.getMetaData().getColumnCount() < GET_COLUMNS_EXTENDED.length ? MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_SHORT) : MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_EXTENDED);
                }
            });
        }
    }

    private final class MetaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = -2821093577201327275L;

        MetaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            ArrayList<Schema> result = new ArrayList<Schema>();
            if (!MetaImpl.this.inverseSchemaCatalog) {
                Result schemas = MetaImpl.this.meta(new MetaFunction(){

                    @Override
                    public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                        return MetaImpl.this.dsl().fetch(meta.getSchemas(), SQLDataType.VARCHAR);
                    }
                });
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            } else {
                Result schemas = MetaImpl.this.meta(new MetaFunction(){

                    @Override
                    public Result<Record> run(DatabaseMetaData meta) throws SQLException {
                        return MetaImpl.this.dsl().fetch(meta.getCatalogs(), SQLDataType.VARCHAR);
                    }
                });
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            }
            if (result.isEmpty()) {
                result.add(new MetaSchema("", this));
            }
            return result;
        }
    }

    private static interface MetaFunction {
        public Result<Record> run(DatabaseMetaData var1) throws SQLException;
    }
}

