/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Check;
import org.jooq.Domain;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Meta;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;

final class FilteredMeta
extends AbstractMeta {
    private static final long serialVersionUID = 2589476339574534267L;
    private final AbstractMeta meta;
    private final Meta.Predicate<? super Catalog> catalogFilter;
    private final Meta.Predicate<? super Schema> schemaFilter;
    private final Meta.Predicate<? super Table<?>> tableFilter;
    private final Meta.Predicate<? super Domain<?>> domainFilter;
    private final Meta.Predicate<? super Sequence<?>> sequenceFilter;
    private final Meta.Predicate<? super UniqueKey<?>> primaryKeyFilter;
    private final Meta.Predicate<? super Index> indexFilter;

    FilteredMeta(AbstractMeta meta, Meta.Predicate<? super Catalog> catalogFilter, Meta.Predicate<? super Schema> schemaFilter, Meta.Predicate<? super Table<?>> tableFilter, Meta.Predicate<? super Domain<?>> domainFilter, Meta.Predicate<? super Sequence<?>> sequenceFilter, Meta.Predicate<? super UniqueKey<?>> primaryKeyFilter, Meta.Predicate<? super Index> indexFilter) {
        super(meta.configuration());
        this.meta = meta;
        this.catalogFilter = catalogFilter;
        this.schemaFilter = schemaFilter;
        this.tableFilter = tableFilter;
        this.domainFilter = domainFilter;
        this.sequenceFilter = sequenceFilter;
        this.primaryKeyFilter = primaryKeyFilter;
        this.indexFilter = indexFilter;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        for (Catalog c : this.meta.getCatalogs()) {
            if (this.catalogFilter != null && !this.catalogFilter.test(c)) continue;
            result.add(new FilteredCatalog(c));
        }
        return result;
    }

    @Override
    public final Meta filterCatalogs(Meta.Predicate<? super Catalog> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter != null ? new And<Catalog>(this.catalogFilter, filter) : filter, this.schemaFilter, this.tableFilter, this.domainFilter, this.sequenceFilter, this.primaryKeyFilter, this.indexFilter);
    }

    @Override
    public final Meta filterSchemas(Meta.Predicate<? super Schema> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter != null ? new And<Schema>(this.schemaFilter, filter) : filter, this.tableFilter, this.domainFilter, this.sequenceFilter, this.primaryKeyFilter, this.indexFilter);
    }

    @Override
    public final Meta filterTables(Meta.Predicate<? super Table<?>> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter, this.tableFilter != null ? new And(this.tableFilter, filter) : filter, this.domainFilter, this.sequenceFilter, this.primaryKeyFilter, this.indexFilter);
    }

    @Override
    public final Meta filterDomains(Meta.Predicate<? super Domain<?>> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter, this.tableFilter, this.domainFilter != null ? new And(this.domainFilter, filter) : filter, this.sequenceFilter, this.primaryKeyFilter, this.indexFilter);
    }

    @Override
    public final Meta filterSequences(Meta.Predicate<? super Sequence<?>> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter, this.tableFilter, this.domainFilter, this.sequenceFilter != null ? new And(this.sequenceFilter, filter) : filter, this.primaryKeyFilter, this.indexFilter);
    }

    @Override
    public final Meta filterPrimaryKeys(Meta.Predicate<? super UniqueKey<?>> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter, this.tableFilter, this.domainFilter, this.sequenceFilter, this.primaryKeyFilter != null ? new And(this.primaryKeyFilter, filter) : filter, this.indexFilter);
    }

    @Override
    public final Meta filterIndexes(Meta.Predicate<? super Index> filter) {
        return new FilteredMeta(this.meta, this.catalogFilter, this.schemaFilter, this.tableFilter, this.domainFilter, this.sequenceFilter, this.primaryKeyFilter, (Meta.Predicate<? super Index>)(this.indexFilter != null ? new And<Index>(this.indexFilter, filter) : filter));
    }

    private class FilteredTable<R extends Record>
    extends TableImpl<R> {
        private static final long serialVersionUID = -6070726881709997500L;
        private final Table<R> delegate;
        private transient List<Index> indexes;
        private transient List<UniqueKey<R>> keys;
        private transient UniqueKey<R> primaryKey;
        private transient List<ForeignKey<R, ?>> references;

        private FilteredTable(FilteredSchema schema, Table<R> delegate) {
            super(delegate.getQualifiedName(), schema, null, null, delegate.getCommentPart(), delegate.getOptions());
            this.delegate = delegate;
            for (Field<?> field : delegate.fields()) {
                FilteredTable.createField(field.getQualifiedName(), field.getDataType(), this, field.getComment());
            }
        }

        @Override
        public final List<Index> getIndexes() {
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
                for (Index index : this.delegate.getIndexes()) {
                    if (FilteredMeta.this.indexFilter != null && !FilteredMeta.this.indexFilter.test(index)) continue;
                    this.indexes.add(index);
                }
            }
            return Collections.unmodifiableList(this.indexes);
        }

        @Override
        public final List<UniqueKey<R>> getKeys() {
            if (this.keys == null) {
                this.keys = new ArrayList<UniqueKey<R>>();
                for (UniqueKey<R> key : this.delegate.getKeys()) {
                    if (key.isPrimary() && FilteredMeta.this.primaryKeyFilter != null && !FilteredMeta.this.primaryKeyFilter.test(key)) continue;
                    this.keys.add(this.key(key));
                }
                UniqueKey<R> pk = this.delegate.getPrimaryKey();
                if (pk != null && (FilteredMeta.this.primaryKeyFilter == null || FilteredMeta.this.primaryKeyFilter.test(pk))) {
                    this.primaryKey = this.key(pk);
                }
            }
            return Collections.unmodifiableList(this.keys);
        }

        private final UniqueKey<R> key(UniqueKey<R> key) {
            TableField<R, ?>[] fields1 = key.getFieldsArray();
            TableField[] fields2 = new TableField[fields1.length];
            for (int i = 0; i < fields2.length; ++i) {
                fields2[i] = (TableField)this.field(fields1[i]);
            }
            return Internal.createUniqueKey(this, key.getName(), fields2, key.enforced());
        }

        @Override
        public final UniqueKey<R> getPrimaryKey() {
            this.getKeys();
            return this.primaryKey;
        }

        @Override
        public final List<ForeignKey<R, ?>> getReferences() {
            if (this.references == null) {
                this.references = new ArrayList();
                for (ForeignKey<R, ?> fk : this.delegate.getReferences()) {
                    UniqueKey<?> uk = FilteredMeta.this.lookupUniqueKey(fk);
                    if (uk == null) continue;
                    this.references.add(AbstractMeta.copyFK(this, uk, fk));
                }
            }
            return Collections.unmodifiableList(this.references);
        }

        @Override
        public final List<Check<R>> getChecks() {
            return this.delegate.getChecks();
        }
    }

    private class FilteredSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -95755926444275258L;
        private final Schema delegate;
        private transient List<Domain<?>> domains;
        private transient List<Table<?>> tables;
        private transient List<Sequence<?>> sequences;

        private FilteredSchema(FilteredCatalog catalog, Schema delegate) {
            super(delegate.getQualifiedName(), (Catalog)catalog, delegate.getCommentPart());
            this.delegate = delegate;
        }

        @Override
        public final List<Domain<?>> getDomains() {
            if (this.domains == null) {
                this.domains = new ArrayList();
                for (Domain<?> d : this.delegate.getDomains()) {
                    if (FilteredMeta.this.domainFilter != null && !FilteredMeta.this.domainFilter.test(d)) continue;
                    this.domains.add(d);
                }
            }
            return Collections.unmodifiableList(this.domains);
        }

        @Override
        public final List<Table<?>> getTables() {
            if (this.tables == null) {
                this.tables = new ArrayList();
                for (Table<?> t : this.delegate.getTables()) {
                    if (FilteredMeta.this.tableFilter != null && !FilteredMeta.this.tableFilter.test(t)) continue;
                    this.tables.add(new FilteredTable(this, t));
                }
            }
            return Collections.unmodifiableList(this.tables);
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            if (this.sequences == null) {
                this.sequences = new ArrayList();
                for (Sequence<?> t : this.delegate.getSequences()) {
                    if (FilteredMeta.this.sequenceFilter != null && !FilteredMeta.this.sequenceFilter.test(t)) continue;
                    this.sequences.add(t);
                }
            }
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public final List<UDT<?>> getUDTs() {
            return this.delegate.getUDTs();
        }
    }

    private class FilteredCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 7979890261252183486L;
        private final Catalog delegate;
        private transient List<Schema> schemas;

        private FilteredCatalog(Catalog delegate) {
            super(delegate.getQualifiedName(), delegate.getCommentPart());
            this.delegate = delegate;
        }

        @Override
        public final List<Schema> getSchemas() {
            if (this.schemas == null) {
                this.schemas = new ArrayList<Schema>();
                for (Schema s : this.delegate.getSchemas()) {
                    if (FilteredMeta.this.schemaFilter != null && !FilteredMeta.this.schemaFilter.test(s)) continue;
                    this.schemas.add(new FilteredSchema(this, s));
                }
            }
            return Collections.unmodifiableList(this.schemas);
        }
    }

    private static class And<Q extends QueryPart>
    implements Meta.Predicate<Q> {
        private final Meta.Predicate<? super Q> p1;
        private final Meta.Predicate<? super Q> p2;

        And(Meta.Predicate<? super Q> p1, Meta.Predicate<? super Q> p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public final boolean test(Q q) {
            return this.p1.test(q) && this.p2.test(q);
        }
    }
}

