/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.Tools;

final class CatalogMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 7582210274970452691L;
    private final Catalog[] catalogs;

    private CatalogMetaImpl(Configuration configuration, Catalog[] catalogs) {
        super(configuration);
        this.catalogs = catalogs;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        return Arrays.asList(this.catalogs);
    }

    static final Meta filterCatalogs(Configuration configuration, Catalog[] catalogs) {
        return CatalogMetaImpl.filterCatalogs0(configuration, catalogs, new LinkedHashSet<Catalog>(Arrays.asList(catalogs)));
    }

    static final Meta filterCatalogs(Configuration configuration, Set<Catalog> catalogs) {
        return CatalogMetaImpl.filterCatalogs0(configuration, catalogs.toArray(Tools.EMPTY_CATALOG), catalogs);
    }

    private static final Meta filterCatalogs0(Configuration configuration, Catalog[] array, final Set<Catalog> set) {
        return new CatalogMetaImpl(configuration, array).filterCatalogs((Meta.Predicate<? super Catalog>)new Meta.Predicate<Catalog>(){

            @Override
            public boolean test(Catalog catalog) {
                return set.contains(catalog);
            }
        });
    }

    static final Meta filterSchemas(Configuration configuration, Schema[] schemas) {
        return CatalogMetaImpl.filterSchemas(configuration, new LinkedHashSet<Schema>(Arrays.asList(schemas)));
    }

    static final Meta filterSchemas(Configuration configuration, final Set<Schema> schemas) {
        Name key;
        LinkedHashMap<Name, 2> c = new LinkedHashMap<Name, 2>();
        final LinkedHashMap<Name, ArrayList<Schema>> mapping = new LinkedHashMap<Name, ArrayList<Schema>>();
        for (Schema schema : schemas) {
            key = AbstractNamed.nameOrDefault(schema.getCatalog());
            ArrayList<Schema> list = (ArrayList<Schema>)mapping.get(key);
            if (list == null) {
                list = new ArrayList<Schema>();
                mapping.put(key, list);
            }
            list.add(schema);
        }
        for (Schema schema : schemas) {
            key = AbstractNamed.nameOrDefault(schema.getCatalog());
            if (c.containsKey(key)) continue;
            c.put(key, new CatalogImpl(key){

                @Override
                public List<Schema> getSchemas() {
                    return (List)mapping.get(this.getQualifiedName());
                }
            });
        }
        return CatalogMetaImpl.filterCatalogs(configuration, new LinkedHashSet<Catalog>(c.values())).filterSchemas((Meta.Predicate<? super Schema>)new Meta.Predicate<Schema>(){

            @Override
            public boolean test(Schema schema) {
                return schemas.contains(schema);
            }
        });
    }

    static final Meta filterTables(Configuration configuration, Table<?>[] tables) {
        return CatalogMetaImpl.filterTables(configuration, new LinkedHashSet(Arrays.asList(tables)));
    }

    static final Meta filterTables(Configuration configuration, final Set<Table<?>> tables) {
        Name key;
        LinkedHashMap<Name, 4> s = new LinkedHashMap<Name, 4>();
        final LinkedHashMap mapping = new LinkedHashMap();
        for (Table<?> table : tables) {
            key = AbstractNamed.nameOrDefault(table.getCatalog()).append(AbstractNamed.nameOrDefault(table.getSchema()));
            ArrayList list = (ArrayList)mapping.get(key);
            if (list == null) {
                list = new ArrayList();
                mapping.put(key, list);
            }
            list.add(table);
        }
        for (Table<?> table : tables) {
            key = AbstractNamed.nameOrDefault(table.getCatalog()).append(AbstractNamed.nameOrDefault(table.getSchema()));
            if (s.containsKey(key)) continue;
            s.put(key, new SchemaImpl(key, table.getCatalog()){

                @Override
                public List<Table<?>> getTables() {
                    return (List)mapping.get(this.getQualifiedName());
                }
            });
        }
        return CatalogMetaImpl.filterSchemas(configuration, new LinkedHashSet<Schema>(s.values())).filterTables(new Meta.Predicate<Table<?>>(){

            @Override
            public boolean test(Table<?> table) {
                return tables.contains(table);
            }
        }).filterSequences(CatalogMetaImpl.none()).filterDomains(CatalogMetaImpl.none());
    }

    static final <Q extends QueryPart> Meta.Predicate<Q> none() {
        return new Meta.Predicate<Q>(){

            @Override
            public boolean test(Q t) {
                return false;
            }
        };
    }
}

