/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.CycleInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapi.profiles.violations.EmptyOneOfAxiom;
import org.semanticweb.owlapi.profiles.violations.IllegalPunning;
import org.semanticweb.owlapi.profiles.violations.InsufficientIndividuals;
import org.semanticweb.owlapi.profiles.violations.InsufficientOperands;
import org.semanticweb.owlapi.profiles.violations.InsufficientPropertyExpressions;
import org.semanticweb.owlapi.profiles.violations.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapi.profiles.violations.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredClass;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUnknownDatatype;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2DLProfile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2 DL";
    }

    @Override
    public IRI getIRI() {
        return Profiles.OWL2_DL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2Profile owl2Profile = new OWL2Profile();
        OWLProfileReport report = owl2Profile.checkOntology(ontology);
        LinkedHashSet<OWLProfileViolation> violations = new LinkedHashSet<OWLProfileViolation>();
        if (!report.isInProfile()) {
            violations.addAll(report.getViolations());
        }
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.importsClosure());
        OWL2DLProfileObjectVisitor visitor = new OWL2DLProfileObjectVisitor(walker);
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    private static class OWL2DLProfileObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private final Set<OWLProfileViolation> profileViolations = new HashSet<OWLProfileViolation>();
        @Nullable
        private OWLObjectPropertyManager objectPropertyManager = null;

        OWL2DLProfileObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.objectPropertyManager == null) {
                this.objectPropertyManager = new OWLObjectPropertyManager(this.getCurrentOntology());
            }
            return OWLAPIPreconditions.verifyNotNull(this.objectPropertyManager);
        }

        @Override
        public void visit(OWLDataOneOf node) {
            if (node.values().count() < 1L) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            if (node.operands().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDataIntersectionOf node) {
            if (node.operands().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            if (ce.operands().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectOneOf ce) {
            if (ce.individuals().count() < 1L) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
        }

        @Override
        public void visit(OWLObjectUnionOf ce) {
            if (ce.operands().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (axiom.classExpressions().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            if (axiom.classExpressions().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            if (axiom.classExpressions().count() < 2L) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (axiom.propertyExpressions().count() < 1L) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            if (axiom.individuals().count() < 2L) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (axiom.individuals().count() < 2L) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLOntology ontology) {
            Optional<IRI> vIRI;
            OWLOntologyID id = ontology.getOntologyID();
            if (id.isAnonymous()) {
                return;
            }
            Optional<IRI> oIRI = id.getOntologyIRI();
            if (oIRI.isPresent() && oIRI.get().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForOntologyIRI(this.getCurrentOntology()));
            }
            if ((vIRI = id.getVersionIRI()).isPresent() && vIRI.get().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForVersionIRI(this.getCurrentOntology()));
            }
        }

        @Override
        public void visit(OWLClass ce) {
            if (!ce.isBuiltIn() && ce.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
            if (!ce.isBuiltIn() && !this.getCurrentOntology().isDeclared(ce, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredClass(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
            if (this.getCurrentOntology().containsDatatypeInSignature(ce.getIRI())) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce.getIRI()));
            }
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!OWL2Datatype.isBuiltIn(node.getIRI())) {
                if (!Namespaces.XSD.inNamespace(node.getIRI()) && !node.isTopDatatype() && node.getIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfUnknownDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
                if (!(node.isTopDatatype() || node.isBuiltIn() || this.getCurrentOntology().isDeclared(node, Imports.INCLUDED))) {
                    this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
            }
            if (this.getCurrentOntology().containsClassInSignature(node.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), node.getIRI()));
            }
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (axiom.getDatatype().getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfBuiltInDatatypeInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
            HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
            LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
            axioms.add(axiom);
            this.getDatatypesInSignature(datatypes, axiom.getDataRange(), axioms);
            if (datatypes.contains(axiom.getDatatype())) {
                this.profileViolations.add(new CycleInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
        }

        private void getDatatypesInSignature(Set<OWLDatatype> datatypes, OWLObject obj, Set<OWLAxiom> axioms) {
            Consumer<OWLDatatypeDefinitionAxiom> addAndRecurse = ax -> {
                axioms.add((OWLAxiom)ax);
                this.getDatatypesInSignature(datatypes, ax.getDataRange(), axioms);
            };
            obj.datatypesInSignature().filter(datatypes::add).forEach(dt -> this.datatypeDefinitions((OWLDatatype)dt).forEach(addAndRecurse));
        }

        protected Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype dt) {
            return Imports.INCLUDED.stream(this.getCurrentOntology()).flatMap(o -> o.datatypeDefinitions(dt));
        }

        @Override
        public void visit(OWLObjectProperty property) {
            if (!property.isOWLTopObjectProperty() && !property.isOWLBottomObjectProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForObjectPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredObjectProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLDataProperty property) {
            if (!property.isOWLTopDataProperty() && !property.isOWLBottomDataProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForDataPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredDataProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
            if (!property.isBuiltIn() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForAnnotationPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredAnnotationProperty(this.getCurrentOntology(), this.getCurrentAxiom(), this.getCurrentAnnotation(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLNamedIndividual individual) {
            if (!individual.isAnonymous() && individual.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForIndividualIRI(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            if (((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLTopDataProperty()) {
                this.profileViolations.add(new UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLObjectMinCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectMaxCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectExactCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectHasSelf ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInObjectHasSelf(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInFunctionalPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInIrreflexivePropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
            axiom.properties().filter(this.getPropertyManager()::isNonSimple).forEach(p -> this.profileViolations.add(new UseOfNonSimplePropertyInDisjointPropertiesAxiom(this.getCurrentOntology(), axiom, (OWLObjectPropertyExpression)p)));
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            OWLObjectPropertyExpression superProp;
            if (axiom.getPropertyChain().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
            if ((superProp = axiom.getSuperProperty()).isOWLTopObjectProperty() || axiom.isEncodingOfTransitiveProperty()) {
                return;
            }
            List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
            OWLObjectPropertyExpression first = chain.get(0);
            OWLObjectPropertyExpression last = chain.get(chain.size() - 1);
            this.checkCenter(axiom, superProp, chain);
            this.checkExtremes(axiom, superProp, first, last);
            this.checkExtremes(axiom, superProp, last, first);
        }

        protected void checkExtremes(OWLSubPropertyChainOfAxiom axiom, OWLObjectPropertyExpression superProp, OWLObjectPropertyExpression first, OWLObjectPropertyExpression last) {
            if (first.equals(superProp)) {
                if (this.getPropertyManager().isLessThan(superProp, last)) {
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, last));
                }
            } else if (this.getPropertyManager().isLessThan(superProp, first)) {
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, first));
            }
        }

        protected void checkCenter(OWLSubPropertyChainOfAxiom axiom, OWLObjectPropertyExpression superProp, List<OWLObjectPropertyExpression> chain) {
            for (int i = 1; i < chain.size() - 1; ++i) {
                if (!this.getPropertyManager().isLessThan(superProp, chain.get(i))) continue;
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, chain.get(i)));
            }
        }
    }
}

