/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.net.Authenticator;
import java.net.http.HttpClient;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdfconnection.LibRDFConn;
import org.apache.jena.rdfconnection.LibSec;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFDatasetConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.apache.jena.rdflink.RDFLinkDatasetBuilder;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public interface RDFConnection
extends SparqlQueryConnection,
SparqlUpdateConnection,
RDFDatasetConnection,
Transactional,
AutoCloseable {
    public static RDFConnection connect(Dataset dataset) {
        return LibRDFConn.adapt(RDFLinkDatasetBuilder.newBuilder().dataset(dataset.asDatasetGraph()).build());
    }

    public static RDFConnection connect(Dataset dataset, Isolation isolation) {
        return LibRDFConn.adapt(RDFLinkDatasetBuilder.newBuilder().dataset(dataset.asDatasetGraph()).isolation(isolation).build());
    }

    public static RDFConnection queryConnect(String queryServiceURL) {
        return RDFConnectionRemote.newBuilder().queryEndpoint(queryServiceURL).queryOnly().build();
    }

    public static RDFConnection connect(String serviceURL) {
        return RDFConnectionRemote.service(serviceURL).build();
    }

    public static RDFConnection connectPW(String URL2, String user, String password) {
        Objects.requireNonNull(URL2);
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        Authenticator authenticator = LibSec.authenticator(user, password);
        HttpClient client = HttpEnv.httpClientBuilder().authenticator(authenticator).build();
        return RDFConnectionRemote.newBuilder().destination(URL2).httpClient(client).build();
    }

    @Override
    default public void queryResultSet(String queryString, Consumer<ResultSet> resultSetAction) {
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(queryString);){
                ResultSet rs = qExec.execSelect();
                resultSetAction.accept(rs);
            }
        });
    }

    @Override
    default public void queryResultSet(Query query, Consumer<ResultSet> resultSetAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                ResultSet rs = qExec.execSelect();
                resultSetAction.accept(rs);
            }
        });
    }

    @Override
    default public void querySelect(String queryString, Consumer<QuerySolution> rowAction) {
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(queryString);){
                qExec.execSelect().forEachRemaining(rowAction);
            }
        });
    }

    @Override
    default public void querySelect(Query query, Consumer<QuerySolution> rowAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                qExec.execSelect().forEachRemaining(rowAction);
            }
        });
    }

    @Override
    default public Model queryConstruct(String queryString) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(queryString);){
                Model model = qExec.execConstruct();
                return model;
            }
        });
    }

    @Override
    default public Model queryConstruct(Query query) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Model model = qExec.execConstruct();
                return model;
            }
        });
    }

    @Override
    default public Model queryDescribe(String queryString) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(queryString);){
                Model model = qExec.execDescribe();
                return model;
            }
        });
    }

    @Override
    default public Model queryDescribe(Query query) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Model model = qExec.execDescribe();
                return model;
            }
        });
    }

    @Override
    default public boolean queryAsk(String queryString) {
        return (Boolean)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(queryString);){
                Boolean bl = qExec.execAsk();
                return bl;
            }
        });
    }

    @Override
    default public boolean queryAsk(Query query) {
        return (Boolean)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Boolean bl = qExec.execAsk();
                return bl;
            }
        });
    }

    @Override
    public QueryExecution query(Query var1);

    @Override
    default public QueryExecution query(String queryString) {
        return this.query(QueryFactory.create((String)queryString));
    }

    @Override
    public QueryExecutionBuilder newQuery();

    @Override
    default public void update(Update update) {
        this.update(new UpdateRequest(update));
    }

    @Override
    public void update(UpdateRequest var1);

    @Override
    default public void update(String updateString) {
        this.update(UpdateFactory.create((String)updateString));
    }

    @Override
    public UpdateExecutionBuilder newUpdate();

    @Override
    public Model fetch(String var1);

    @Override
    public Model fetch();

    @Override
    public Dataset fetchDataset();

    @Override
    public void load(String var1, String var2);

    @Override
    public void load(String var1);

    @Override
    public void load(String var1, Model var2);

    @Override
    public void load(Model var1);

    @Override
    public void put(String var1, String var2);

    @Override
    public void put(String var1);

    @Override
    public void put(String var1, Model var2);

    @Override
    public void put(Model var1);

    @Override
    public void delete(String var1);

    @Override
    public void delete();

    @Override
    public void loadDataset(String var1);

    @Override
    public void loadDataset(Dataset var1);

    @Override
    public void putDataset(String var1);

    @Override
    public void putDataset(Dataset var1);

    @Override
    public boolean isClosed();

    @Override
    public void close();
}

