/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix2D;

class SelectedDenseDoubleMatrix3D
extends DoubleMatrix3D {
    protected double[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDoubleMatrix3D(double[] elements, int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets, int offset) {
        int slices = sliceOffsets.length;
        int rows = rowOffsets.length;
        int columns = columnOffsets.length;
        this.setUp(slices, rows, columns);
        this.elements = elements;
        this.sliceOffsets = sliceOffsets;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected int _sliceOffset(int absRank) {
        return this.sliceOffsets[absRank];
    }

    @Override
    public double getQuick(int slice, int row, int column) {
        return this.elements[this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        if (other instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D otherMatrix = (SelectedDenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D otherMatrix = (DenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int slice, int row, int column) {
        return this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new DenseDoubleMatrix3D(slices, rows, columns);
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int slice, int row, int column, double value) {
        this.elements[this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]] = value;
    }

    @Override
    protected void setUp(int slices, int rows, int columns) {
        super.setUp(slices, rows, columns);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        super.vDice(axis0, axis1, axis2);
        int[][] offsets = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = offsets[axis0];
        this.rowOffsets = offsets[axis1];
        this.columnOffsets = offsets[axis2];
        return this;
    }

    @Override
    public DoubleMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int viewRows = this.slices;
        int viewColumns = this.rows;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.rowZero;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.rowStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.rowOffsets;
        return new SelectedDenseDoubleMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    public DoubleMatrix2D viewRow(int row) {
        this.checkRow(row);
        int viewRows = this.slices;
        int viewColumns = this.columns;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseDoubleMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDoubleMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, this.offset);
    }

    @Override
    public DoubleMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int viewRows = this.rows;
        int viewColumns = this.columns;
        int viewRowZero = this.rowZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._sliceOffset(this._sliceRank(slice));
        int viewRowStride = this.rowStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.rowOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseDoubleMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }
}

