/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.WrapperDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;

public class RCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    protected IntArrayList indexes;
    protected DoubleArrayList values;
    protected int[] starts;

    public RCDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public RCDoubleMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.indexes = new IntArrayList();
        this.values = new DoubleArrayList();
        this.starts = new int[rows + 1];
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        if (value == 0.0) {
            this.indexes.clear();
            this.values.clear();
            int i = this.starts.length;
            while (--i >= 0) {
                this.starts[i] = 0;
            }
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleFunction function) {
        if (function instanceof Mult) {
            double alpha = ((Mult)function).multiplicator;
            if (alpha == 1.0) {
                return this;
            }
            if (alpha == 0.0) {
                return this.assign(0.0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            double[] vals = this.values.elements();
            int j = this.values.size();
            while (--j >= 0) {
                int n = j;
                vals[n] = vals[n] * alpha;
            }
        } else {
            super.assign(function);
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (!(source instanceof RCDoubleMatrix2D)) {
            this.assign(0.0);
            source.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    RCDoubleMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
            return this;
        }
        RCDoubleMatrix2D other = (RCDoubleMatrix2D)source;
        System.arraycopy(other.starts, 0, this.starts, 0, this.starts.length);
        int s = other.indexes.size();
        this.indexes.setSize(s);
        this.values.setSize(s);
        this.indexes.replaceFromToWithFrom(0, s - 1, other.indexes, 0);
        this.values.replaceFromToWithFrom(0, s - 1, other.values, 0);
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        if (function instanceof PlusMult) {
            final double alpha = ((PlusMult)function).multiplicator;
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    RCDoubleMatrix2D.this.setQuick(i, j, RCDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function == Functions.mult) {
            int[] idx = this.indexes.elements();
            double[] vals = this.values.elements();
            int i = this.starts.length - 1;
            while (--i >= 0) {
                int low = this.starts[i];
                int k = this.starts[i + 1];
                while (--k >= low) {
                    int j = idx[k];
                    int n = k;
                    vals[n] = vals[n] * y.getQuick(i, j);
                    if (vals[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == Functions.div) {
            int[] idx = this.indexes.elements();
            double[] vals = this.values.elements();
            int i = this.starts.length - 1;
            while (--i >= 0) {
                int low = this.starts[i];
                int k = this.starts[i + 1];
                while (--k >= low) {
                    int j = idx[k];
                    int n = k;
                    vals[n] = vals[n] / y.getQuick(i, j);
                    if (vals[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        int[] idx = this.indexes.elements();
        double[] vals = this.values.elements();
        int i = this.starts.length - 1;
        while (--i >= 0) {
            int low = this.starts[i];
            int k = this.starts[i + 1];
            while (--k >= low) {
                int j = idx[k];
                double value = vals[k];
                double r = function.apply(i, j, value);
                if (r == value) continue;
                vals[k] = r;
            }
        }
        return this;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this;
    }

    @Override
    public double getQuick(int row, int column) {
        int k = this.indexes.binarySearchFromTo(column, this.starts[row], this.starts[row + 1] - 1);
        double v = 0.0;
        if (k >= 0) {
            v = this.values.getQuick(k);
        }
        return v;
    }

    protected void insert(int row, int column, int index, double value) {
        this.indexes.beforeInsert(index, column);
        this.values.beforeInsert(index, value);
        int i = this.starts.length;
        while (--i > row) {
            int n = i;
            this.starts[n] = this.starts[n] + 1;
        }
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new RCDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    protected void remove(int row, int index) {
        this.indexes.remove(index);
        this.values.remove(index);
        int i = this.starts.length;
        while (--i > row) {
            int n = i;
            this.starts[n] = this.starts[n] - 1;
        }
    }

    @Override
    public void setQuick(int row, int column, double value) {
        int k = this.indexes.binarySearchFromTo(column, this.starts[row], this.starts[row + 1] - 1);
        if (k >= 0) {
            if (value == 0.0) {
                this.remove(row, k);
            } else {
                this.values.setQuick(k, value);
            }
            return;
        }
        if (value != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    @Override
    public void trimToSize() {
        this.indexes.trimToSize();
        this.values.trimToSize();
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        boolean ignore;
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseDoubleMatrix1D(m);
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if (n != y.size() || m > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        double[] zElements = zz.elements;
        int zStride = zz.stride;
        int zi = z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        double[] yElements = yy.elements;
        int yStride = yy.stride;
        int yi = y.index(0);
        if (yElements == null || zElements == null) {
            throw new InternalError();
        }
        int[] idx = this.indexes.elements();
        double[] vals = this.values.elements();
        int s = this.starts.length - 1;
        if (!transposeA) {
            for (int i = 0; i < s; ++i) {
                int high = this.starts[i + 1];
                double sum = 0.0;
                for (int k = this.starts[i]; k < high; ++k) {
                    int j = idx[k];
                    sum += vals[k] * yElements[yi + yStride * j];
                }
                zElements[zi] = alpha * sum + beta * zElements[zi];
                zi += zStride;
            }
        } else {
            if (!ignore) {
                z.assign(Functions.mult(beta));
            }
            for (int i = 0; i < s; ++i) {
                int high = this.starts[i + 1];
                double yElem = alpha * yElements[yi + yStride * i];
                for (int k = this.starts[i]; k < high; ++k) {
                    int j = idx[k];
                    int n2 = zi + zStride * j;
                    zElements[n2] = zElements[n2] + vals[k] * yElem;
                }
            }
        }
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (transposeB) {
            B = B.viewDice();
        }
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        int p = B.columns;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseDoubleMatrix2D(m, p);
        }
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows != m || C.columns != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(Functions.mult(beta));
        }
        DoubleMatrix1D[] Brows = new DoubleMatrix1D[n];
        int i = n;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        DoubleMatrix1D[] Crows = new DoubleMatrix1D[m];
        int i2 = m;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        PlusMult fun = PlusMult.plusMult(0.0);
        int[] idx = this.indexes.elements();
        double[] vals = this.values.elements();
        int i3 = this.starts.length - 1;
        while (--i3 >= 0) {
            int low = this.starts[i3];
            int k = this.starts[i3 + 1];
            while (--k >= low) {
                int j = idx[k];
                fun.multiplicator = vals[k] * alpha;
                if (!transposeA) {
                    Crows[i3].assign(Brows[j], fun);
                    continue;
                }
                Crows[j].assign(Brows[i3], fun);
            }
        }
        return C;
    }
}

