/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Timer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import cern.jet.random.sampling.RandomSampler;

public class Statistic {
    private static final Functions F = Functions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            F;
            F;
            F;
            F;
            return Math.sqrt(a.aggregate(b, Functions.plus, Functions.chain(Functions.square, Functions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            F;
            F;
            F;
            F;
            double d = a.aggregate(b, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
            F;
            F;
            return d / a.aggregate(b, Functions.plus, Functions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        DoubleDoubleFunction fun = new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return Math.abs(a - b) / Math.abs(a + b);
            }
        };

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            F;
            return a.aggregate(b, Functions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            F;
            F;
            F;
            F;
            return a.aggregate(b, Functions.max, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            F;
            F;
            F;
            F;
            return a.aggregate(b, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
        }
    };

    protected Statistic() {
    }

    public static DoubleMatrix2D correlation(DoubleMatrix2D covariance) {
        int i = covariance.columns();
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double stdDev1 = Math.sqrt(covariance.getQuick(i, i));
                double stdDev2 = Math.sqrt(covariance.getQuick(j, j));
                double cov = covariance.getQuick(i, j);
                double corr = cov / (stdDev1 * stdDev2);
                covariance.setQuick(i, j, corr);
                covariance.setQuick(j, i, corr);
            }
        }
        i = covariance.columns();
        while (--i >= 0) {
            covariance.setQuick(i, i, 1.0);
        }
        return covariance;
    }

    public static DoubleMatrix2D covariance(DoubleMatrix2D matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        DenseDoubleMatrix2D covariance = new DenseDoubleMatrix2D(columns, columns);
        double[] sums = new double[columns];
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
            sums[i] = cols[i].zSum();
        }
        i = columns;
        while (--i >= 0) {
            int j = i + 1;
            while (--j >= 0) {
                double sumOfProducts = cols[i].zDotProduct(cols[j]);
                double cov = (sumOfProducts - sums[i] * sums[j] / (double)rows) / (double)rows;
                ((DoubleMatrix2D)covariance).setQuick(i, j, cov);
                ((DoubleMatrix2D)covariance).setQuick(j, i, cov);
            }
        }
        return covariance;
    }

    public static void demo1() {
        double[][] values = new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 6.0}, {3.0, 6.0, 9.0}, {4.0, -8.0, -10.0}};
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.make(values);
        System.out.println("\n\nmatrix=" + A);
        System.out.println("\ncovar1=" + Statistic.covariance(A));
    }

    public static void demo2(int rows, int columns, boolean print) {
        System.out.println("\n\ninitializing...");
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.ascending(rows, columns);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        DoubleMatrix2D corr = Statistic.correlation(Statistic.covariance(A));
        timer.stop().display();
        if (print) {
            System.out.println("printing result...");
            System.out.println(corr);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction norm) {
        double[][] values = new double[][]{{-0.9611052, -0.25421095}, {0.4308269, -0.69932648}, {-1.2071029, 0.62030596}, {1.5345166, 0.02135884}, {-1.1341542, 0.2038843}};
        System.out.println("\n\ninitializing...");
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.make(values).viewDice();
        System.out.println("\nA=" + A.viewDice());
        System.out.println("\ndist=" + Statistic.distance(A, norm).viewDice());
    }

    public static DoubleMatrix2D distance(DoubleMatrix2D matrix, VectorVectorFunction distanceFunction) {
        int columns = matrix.columns();
        DenseDoubleMatrix2D distance = new DenseDoubleMatrix2D(columns, columns);
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
        }
        i = columns;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double d = distanceFunction.apply(cols[i], cols[j]);
                ((DoubleMatrix2D)distance).setQuick(i, j, d);
                ((DoubleMatrix2D)distance).setQuick(j, i, d);
            }
        }
        return distance;
    }

    public static void main(String[] args) {
        int rows = Integer.parseInt(args[0]);
        int columns = Integer.parseInt(args[1]);
        boolean print = args[2].equals("print");
        Statistic.demo2(rows, columns, print);
    }

    public static DoubleMatrix1D viewSample(DoubleMatrix1D matrix, double fraction, RandomEngine randomGenerator) {
        int ncols;
        double epsilon = 1.0E-9;
        if (fraction < 0.0 - epsilon || fraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (fraction < 0.0) {
            fraction = 0.0;
        }
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int max = ncols = (int)Math.round((double)matrix.size() * fraction);
        long[] selected = new long[max];
        int n = ncols;
        int N = matrix.size();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedCols);
    }

    public static DoubleMatrix2D viewSample(DoubleMatrix2D matrix, double rowFraction, double columnFraction, RandomEngine randomGenerator) {
        double epsilon = 1.0E-9;
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncols = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nrows, ncols);
        long[] selected = new long[max];
        int n = nrows;
        int N = matrix.rows();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncols;
        N = matrix.columns();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedRows, selectedCols);
    }

    public static DoubleMatrix3D viewSample(DoubleMatrix3D matrix, double sliceFraction, double rowFraction, double columnFraction, RandomEngine randomGenerator) {
        double epsilon = 1.0E-9;
        if (sliceFraction < 0.0 - epsilon || sliceFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (sliceFraction < 0.0) {
            sliceFraction = 0.0;
        }
        if (sliceFraction > 1.0) {
            sliceFraction = 1.0;
        }
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int nslices = (int)Math.round((double)matrix.slices() * sliceFraction);
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncols = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nslices, Math.max(nrows, ncols));
        long[] selected = new long[max];
        int n = nslices;
        int N = matrix.slices();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedSlices = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedSlices[i] = (int)selected[i];
        }
        n = nrows;
        N = matrix.rows();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncols;
        N = matrix.columns();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedSlices, selectedRows, selectedCols);
    }

    private static DoubleMatrix2D xdistanceOld(DoubleMatrix2D matrix, int norm) {
        return null;
    }

    private static DoubleMatrix2D xdistanceOld2(DoubleMatrix2D matrix, int norm) {
        return null;
    }

    public static interface VectorVectorFunction {
        public double apply(DoubleMatrix1D var1, DoubleMatrix1D var2);
    }
}

