/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.base;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryWrapper;
import org.openrdf.repository.event.NotifyingRepository;
import org.openrdf.repository.event.NotifyingRepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionListener;
import org.openrdf.repository.event.RepositoryListener;
import org.openrdf.repository.event.base.NotifyingRepositoryConnectionWrapper;

public class NotifyingRepositoryWrapper
extends RepositoryWrapper
implements NotifyingRepository {
    private boolean activated;
    private boolean defaultReportDeltas = false;
    private Set<RepositoryListener> listeners = new CopyOnWriteArraySet<RepositoryListener>();
    private Set<RepositoryConnectionListener> conListeners = new CopyOnWriteArraySet<RepositoryConnectionListener>();

    public NotifyingRepositoryWrapper() {
    }

    public NotifyingRepositoryWrapper(Repository delegate) {
        super(delegate);
    }

    public NotifyingRepositoryWrapper(Repository delegate, boolean defaultReportDeltas) {
        this(delegate);
        this.setDefaultReportDeltas(defaultReportDeltas);
    }

    public boolean getDefaultReportDeltas() {
        return this.defaultReportDeltas;
    }

    public void setDefaultReportDeltas(boolean defaultReportDeltas) {
        this.defaultReportDeltas = defaultReportDeltas;
    }

    @Override
    public void addRepositoryListener(RepositoryListener listener) {
        this.listeners.add(listener);
        this.activated = true;
    }

    @Override
    public void removeRepositoryListener(RepositoryListener listener) {
        this.listeners.remove(listener);
        this.activated = !this.listeners.isEmpty();
    }

    @Override
    public void addRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.conListeners.add(listener);
    }

    @Override
    public void removeRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.conListeners.remove(listener);
    }

    public NotifyingRepositoryConnection getConnection() throws RepositoryException {
        RepositoryConnection con = this.getDelegate().getConnection();
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.getConnection(this.getDelegate(), con);
            }
        }
        NotifyingRepositoryConnectionWrapper ncon = new NotifyingRepositoryConnectionWrapper(this, con, this.getDefaultReportDeltas());
        for (RepositoryConnectionListener l : this.conListeners) {
            ncon.addRepositoryConnectionListener(l);
        }
        return ncon;
    }

    public void initialize() throws RepositoryException {
        super.initialize();
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.initialize(this.getDelegate());
            }
        }
    }

    public void setDataDir(File dataDir) {
        super.setDataDir(dataDir);
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.setDataDir(this.getDelegate(), dataDir);
            }
        }
    }

    public void shutDown() throws RepositoryException {
        super.shutDown();
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.shutDown(this.getDelegate());
            }
        }
    }
}

