/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.util.MillisecondTimestampFactory;

public class TimestampChooser
implements IRowStoreConstants {
    public static long chooseTimestamp(IIndex ndx, long timestamp) {
        if (timestamp == -1L) {
            return System.currentTimeMillis();
        }
        if (timestamp == -2L) {
            BTree mutableBTree = ((ILocalBTreeView)ndx).getMutableBTree();
            if (mutableBTree.getStore() instanceof TemporaryRawStore) {
                return MillisecondTimestampFactory.nextMillis();
            }
            IJournal journal = (IJournal)mutableBTree.getStore();
            return journal.getLocalTransactionManager().nextTimestamp();
        }
        return timestamp;
    }
}

