/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.counters.CounterSet;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.ndx.IndexSyncRPCCounters;
import com.bigdata.service.ndx.pipeline.IndexAsyncWriteStats;

public class ScaleOutIndexCounters {
    public final IndexAsyncWriteStats asynchronousStats;
    public final IndexSyncRPCCounters synchronousCounters;

    public ScaleOutIndexCounters(AbstractFederation fed) {
        this.asynchronousStats = new IndexAsyncWriteStats(fed);
        this.synchronousCounters = new IndexSyncRPCCounters();
    }

    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.makePath("synchronous").attach(this.synchronousCounters.getCounters());
        counterSet.makePath("asynchronous").attach(this.asynchronousStats.getCounterSet());
        return counterSet;
    }

    public String toString() {
        return this.getClass().getName() + "{asynchronous=" + this.asynchronousStats + ", synchronous=" + this.synchronousCounters + "}";
    }
}

