/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.relation.IMutableRelationIndexWriteProcedure;

public class JustIndexWriteProc
extends AbstractKeyArrayIndexProcedure<Long>
implements IParallelizableIndexProcedure<Long>,
IMutableRelationIndexWriteProcedure<Long> {
    private static final long serialVersionUID = -7469842097766417950L;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public JustIndexWriteProc() {
    }

    public JustIndexWriteProc(IRabaCoder keySer, int fromIndex, int toIndex, byte[][] keys) {
        super(keySer, null, fromIndex, toIndex, keys, null);
    }

    @Override
    public Long applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        long nwritten = 0L;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            byte[] key = keys.get(i);
            if (ndx.contains(key)) continue;
            ndx.insert(key, null);
            ++nwritten;
        }
        return nwritten;
    }

    @Override
    protected IResultHandler<Long, Long> newAggregator() {
        return new LongAggregator();
    }

    public static class WriteJustificationsProcConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<JustIndexWriteProc> {
        public static WriteJustificationsProcConstructor INSTANCE = new WriteJustificationsProcConstructor();

        @Override
        public final boolean sendValues() {
            return false;
        }

        private WriteJustificationsProcConstructor() {
        }

        @Override
        public JustIndexWriteProc newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            assert (vals == null);
            return new JustIndexWriteProc(keySer, fromIndex, toIndex, keys);
        }
    }
}

