/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNodeContainer;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;

public class ASTSetValueExpressionsOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot query = (QueryRoot)queryNode;
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        this.convert2(context.context, globals, query);
        return new QueryNodeWithBindingSet(query, bindingSets);
    }

    private void convert2(BOpContextBase context, GlobalAnnotations globals, QueryRoot query) {
        IStriterator it = new Striterator(BOpUtility.preOrderIteratorWithAnnotations(query)).addFilter((IFilter)new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean isValid(Object obj) {
                if (obj instanceof IValueExpressionNodeContainer) {
                    return true;
                }
                if (obj instanceof HavingNode) {
                    return true;
                }
                return obj instanceof StatementPatternNode;
            }
        });
        while (it.hasNext()) {
            StatementPatternNode sp;
            RangeNode range;
            Object op = it.next();
            if (op instanceof IValueExpressionNodeContainer) {
                AST2BOpUtility.toVE(context, globals, ((IValueExpressionNodeContainer)op).getValueExpressionNode());
                continue;
            }
            if (op instanceof HavingNode) {
                HavingNode havingNode = (HavingNode)op;
                for (IValueExpressionNode node : havingNode) {
                    AST2BOpUtility.toVE(context, globals, node);
                }
                continue;
            }
            if (!(op instanceof StatementPatternNode) || (range = (sp = (StatementPatternNode)op).getRange()) == null) continue;
            if (range.from() != null) {
                AST2BOpUtility.toVE(context, globals, range.from());
            }
            if (range.to() == null) continue;
            AST2BOpUtility.toVE(context, globals, range.to());
        }
    }
}

