/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.Var;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.HashSet;
import java.util.List;

public class ASTOrderByAggregateFlatteningOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            List<NamedSubqueryRoot> list = BOpUtility.toList(namedSubqueries, NamedSubqueryRoot.class);
            for (NamedSubqueryRoot namedSubquery : list) {
                this.doSelectQuery(context, namedSubquery);
            }
        }
        this.doSelectQuery(context, (QueryRoot)queryNode);
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private void doSelectQuery(AST2BOpContext context, QueryBase queryBase) {
        this.doRecursiveRewrite(context, queryBase.getWhereClause());
        if (queryBase.getQueryType() != QueryType.SELECT) {
            return;
        }
        ProjectionNode projection = queryBase.getProjection();
        OrderByNode orderBy = queryBase.getOrderBy();
        OrderByNode newOrderBy = new OrderByNode();
        boolean aggregatesPresent = false;
        if (orderBy == null) {
            return;
        }
        HashSet varsToExcludeFromProjection = new HashSet();
        for (OrderByExpr orderByExpr : orderBy) {
            IValueExpression<? extends IV> ve = orderByExpr.getValueExpression();
            IValueExpressionNode ven = orderByExpr.getValueExpressionNode();
            if (ve instanceof AggregateBase) {
                aggregatesPresent = true;
                Var<IV> freshVar = Var.var();
                VarNode newVEN = new VarNode(freshVar);
                OrderByExpr newOrderByExpr = new OrderByExpr(newVEN, orderByExpr.isAscending());
                newOrderBy.addExpr(newOrderByExpr);
                AssignmentNode replacementAlias = new AssignmentNode(newVEN, ven);
                projection.addProjectionExpression(replacementAlias);
                varsToExcludeFromProjection.add(freshVar);
                continue;
            }
            newOrderBy.addExpr(orderByExpr);
        }
        projection.setVarsToExcludeFromProjection(varsToExcludeFromProjection);
        if (!aggregatesPresent) {
            return;
        }
        queryBase.setOrderBy(newOrderBy);
    }

    private void doRecursiveRewrite(AST2BOpContext context, GraphPatternGroup<IGroupMemberNode> group) {
        if (group == null) {
            return;
        }
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = group.get(i);
            if (child instanceof GraphPatternGroup) {
                this.doRecursiveRewrite(context, (GraphPatternGroup)child);
                continue;
            }
            if (child instanceof SubqueryRoot) {
                SubqueryRoot subqueryRoot = (SubqueryRoot)child;
                this.doRecursiveRewrite(context, subqueryRoot.getWhereClause());
                this.doSelectQuery(context, (SubqueryBase)child);
                continue;
            }
            if (!(child instanceof ServiceNode)) continue;
        }
    }
}

