/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ITransactionService;
import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.Quorum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class CreateKBTask
extends AbstractApiTask<Void> {
    private static final transient Logger log = Logger.getLogger(CreateKBTask.class);
    private static final transient Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    private final Properties properties;

    protected Properties getProperties() {
        return this.properties;
    }

    public CreateKBTask(String namespace, Properties properties) {
        super(namespace, 0L, true);
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = new Properties(properties);
        this.properties.setProperty(BigdataSail.Options.NAMESPACE, namespace);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.doRun();
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, AsynchronousQuorumCloseException.class)) {
                log.warn((Object)t);
            } else {
                log.error((Object)t, t);
            }
            throw new Exception(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws Exception {
        IIndexManager indexManager = this.getIndexManager();
        if (indexManager instanceof IJournal) {
            boolean isSoloOrLeader;
            final IJournal jnl = (IJournal)indexManager;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = jnl.getQuorum();
            if (quorum == null) {
                isSoloOrLeader = true;
            } else {
                long token;
                try {
                    long tmp = quorum.token();
                    if (tmp == -1L) {
                        log.warn((Object)"Awaiting quorum.");
                        tmp = quorum.awaitQuorum();
                    }
                    token = tmp;
                    assert (token != -1L);
                }
                catch (AsynchronousQuorumCloseException e1) {
                    throw new RuntimeException(e1);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                try {
                    jnl.awaitHAReady(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (AsynchronousQuorumCloseException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                isSoloOrLeader = quorum.getMember().isLeader(token);
                IJournal journal = jnl;
                if (journal.isGroupCommit() && journal.getRootBlockView().getCommitCounter() == 0L) {
                    journal.getGlobalRowStore();
                    journal.commit();
                }
            }
            if (isSoloOrLeader) {
                final BigdataSail sail = new BigdataSail(this.namespace, this.getIndexManager());
                try {
                    sail.initialize();
                    BigdataSail.UnisolatedCallable<Void> task = new BigdataSail.UnisolatedCallable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (!sail.exists()) {
                                CreateKBTask.this.createLTS(jnl, CreateKBTask.this.getProperties());
                                if (txLog.isInfoEnabled()) {
                                    txLog.info((Object)("SAIL-CREATE-NAMESPACE: namespace=" + CreateKBTask.this.namespace));
                                }
                            }
                            return null;
                        }
                    };
                    try {
                        sail.getUnisolatedConnectionLocksAndRunLambda(task);
                    }
                    finally {
                        task.releaseLocks();
                    }
                }
                finally {
                    sail.shutDown();
                }
            }
        } else if (indexManager.getResourceLocator().locate(this.namespace, 0L) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating KB instance: namespace=" + this.namespace));
            }
            ScaleOutTripleStore lts = new ScaleOutTripleStore(indexManager, this.namespace, 0L, this.getProperties());
            lts.create();
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("CREATE: namespace=" + this.namespace));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLTS(IJournal indexManager, Properties properties) throws IOException {
        String namespace = properties.getProperty(BigdataSail.Options.NAMESPACE, "kb");
        BigdataSail.checkProperties(properties);
        if (Boolean.parseBoolean(properties.getProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false"))) {
            ITransactionService txService = indexManager.getLocalTransactionManager().getTransactionService();
            long txIdCreate = txService.newTx(0L);
            boolean ok = false;
            try {
                LocalTripleStore txCreateView = new LocalTripleStore(indexManager, namespace, txIdCreate, properties);
                txCreateView.create();
                txService.commit(txIdCreate);
                ok = true;
            }
            finally {
                if (!ok) {
                    txService.abort(txIdCreate);
                }
            }
        } else {
            LocalTripleStore lts = new LocalTripleStore(indexManager, namespace, 0L, properties);
            lts.create();
        }
    }
}

