/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

public enum StatementEnum {
    Explicit(0),
    Axiom(1),
    Inferred(2),
    History(3);

    private final byte code;
    public static final int MASK_OVERRIDE = 8;
    public static final int MASK_USER_FLAG = 4;

    private StatementEnum(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public static StatementEnum max(StatementEnum a, StatementEnum b) {
        if (a.code < b.code) {
            return a;
        }
        return b;
    }

    public static StatementEnum decode(byte b) {
        switch (b & 0xFFFFFFF7 & 0xFFFFFFFB) {
            case 0: {
                return Explicit;
            }
            case 1: {
                return Axiom;
            }
            case 2: {
                return Inferred;
            }
            case 3: {
                return History;
            }
        }
        throw new RuntimeException("Unexpected byte: " + b);
    }

    public static StatementEnum deserialize(byte[] val) {
        if (val.length != 1) {
            throw new RuntimeException("Expecting one byte, not " + val.length);
        }
        return StatementEnum.decode(val[0]);
    }

    public byte[] serialize() {
        return new byte[]{this.code};
    }

    public static boolean isUserFlag(byte b) {
        return (b & 4) != 0;
    }

    public static boolean isOverride(byte b) {
        return (b & 8) != 0;
    }
}

