/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.rdf.load.IStatementBufferFactory;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.rio.LoadStats;
import com.bigdata.rdf.rio.PresortRioLoader;
import com.bigdata.rdf.rio.RDFParserOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;

public class SingleResourceReaderTask
implements Runnable {
    protected static final Logger log = Logger.getLogger(SingleResourceReaderTask.class);
    final String resource;
    final String baseURL;
    final RDFFormat rdfFormat;
    final RDFParserOptions parserOptions;
    final boolean deleteAfter;
    final IStatementBufferFactory bufferFactory;
    final AtomicLong toldTriples;
    final long createTime;

    public String toString() {
        return "LoadTask{ resource=" + this.resource + ", elapsed=" + (System.currentTimeMillis() - this.createTime) + "}";
    }

    public SingleResourceReaderTask(String resource, String baseURL, RDFFormat rdfFormat, RDFParserOptions parserOptions, boolean deleteAfter, IStatementBufferFactory bufferFactory, AtomicLong toldTriples) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (baseURL == null) {
            throw new IllegalArgumentException();
        }
        if (rdfFormat == null) {
            throw new IllegalArgumentException();
        }
        if (parserOptions == null) {
            throw new IllegalArgumentException();
        }
        if (bufferFactory == null) {
            throw new IllegalArgumentException();
        }
        if (toldTriples == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
        this.baseURL = baseURL;
        this.rdfFormat = rdfFormat;
        this.parserOptions = parserOptions;
        this.deleteAfter = deleteAfter;
        this.bufferFactory = bufferFactory;
        this.toldTriples = toldTriples;
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        LoadStats loadStats;
        try {
            loadStats = this.readData();
        }
        catch (Exception e) {
            log.warn((Object)("resource=" + this.resource + ", error=" + e));
            throw new RuntimeException("resource=" + this.resource + " : " + e, e);
        }
        this.toldTriples.addAndGet(loadStats.toldTriples.get());
    }

    protected LoadStats readData() throws Exception {
        long begin = System.currentTimeMillis();
        IStatementBuffer buffer = this.bufferFactory.newStatementBuffer();
        buffer.reset();
        if (log.isInfoEnabled()) {
            log.info((Object)("loading: " + this.resource));
        }
        PresortRioLoader loader = new PresortRioLoader(buffer);
        FileInputStream rdfStream = new FileInputStream(this.resource);
        BufferedReader reader = new BufferedReader(new InputStreamReader(rdfStream));
        boolean success = false;
        try {
            LoadStats stats = new LoadStats();
            loader.loadRdf(reader, this.baseURL, this.rdfFormat, null, this.parserOptions);
            success = true;
            long nstmts = loader.getStatementsAdded();
            long now = System.currentTimeMillis();
            stats.toldTriples.set(nstmts);
            stats.totalTime.set(now - begin);
            stats.loadTime.set(now - begin);
            if (log.isInfoEnabled()) {
                log.info((Object)stats.toString());
            }
            LoadStats loadStats = stats;
            return loadStats;
        }
        catch (Exception ex) {
            buffer.reset();
            throw ex;
        }
        finally {
            ((Reader)reader).close();
            ((InputStream)rdfStream).close();
            if (this.deleteAfter && success && !new File(this.resource).delete()) {
                log.warn((Object)("Could not delete: " + this.resource));
            }
        }
    }
}

