/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Id2TermTupleSerializer
extends DefaultTupleSerializer<IV, BigdataValue> {
    private static final long serialVersionUID = 4841769875819006615L;
    private String namespace;
    private transient BigdataValueSerializer<BigdataValue> valueSer;
    private static final transient int INITIAL_CAPACITY = 128;
    private final transient DataOutputBuffer buf = new DataOutputBuffer(128);
    private final transient ByteArrayBuffer tbuf = new ByteArrayBuffer(128);
    private transient BigdataValueFactory valueFactory;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public Id2TermTupleSerializer() {
    }

    public Id2TermTupleSerializer(String namespace, BigdataValueFactory valueFactory) {
        this(namespace, valueFactory, new ASCIIKeyBuilderFactory(9), Id2TermTupleSerializer.getDefaultLeafKeysCoder(), SimpleRabaCoder.INSTANCE);
    }

    public Id2TermTupleSerializer(String namespace, BigdataValueFactory valueFactory, IKeyBuilderFactory keyBuilderFactory, IRabaCoder leafKeysCoder, IRabaCoder leafValsCoder) {
        super(keyBuilderFactory, leafKeysCoder, leafValsCoder);
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
        this.valueFactory = valueFactory;
        this.valueSer = this.valueFactory.getValueSerializer();
    }

    public byte[] id2key(TermId<?> tid) {
        return tid.encode(this.getKeyBuilder().reset()).getKey();
    }

    @Override
    public IV deserializeKey(ITuple tuple) {
        byte[] key = tuple.getKeyBuffer().array();
        return IVUtility.decode(key);
    }

    @Override
    public byte[] serializeKey(Object obj) {
        return this.id2key((TermId)obj);
    }

    @Override
    public byte[] serializeVal(BigdataValue obj) {
        return this.valueSer.serialize(obj, this.buf.reset(), this.tbuf);
    }

    @Override
    public BigdataValue deserialize(ITuple tuple) {
        IV iv = this.deserializeKey(tuple);
        BigdataValue tmp = this.valueSer.deserialize(tuple.getValueStream(), new StringBuilder());
        tmp.setIV(iv);
        return tmp;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String valueFactoryClass;
        String namespace;
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                namespace = in.readUTF();
                valueFactoryClass = in.readUTF();
                break;
            }
            default: {
                throw new IOException("unknown version=" + version);
            }
        }
        this.namespace = namespace;
        try {
            Class<?> vfc = Class.forName(valueFactoryClass);
            if (!BigdataValueFactory.class.isAssignableFrom(vfc)) {
                throw new RuntimeException(AbstractTripleStore.Options.VALUE_FACTORY_CLASS + ": Must extend: " + BigdataValueFactory.class.getName());
            }
            Method gi = vfc.getMethod("getInstance", String.class);
            this.valueFactory = (BigdataValueFactory)gi.invoke(null, namespace);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        this.valueSer = this.valueFactory.getValueSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        out.writeUTF(this.namespace);
        out.writeUTF(this.valueFactory.getClass().getName());
    }
}

