/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.ICoordinate;

public class CoordinateUtility {
    public static double metersPerSecondOfLatitudeAtSeaLevel = 30.82;
    public static double metersPerMinuteOfLatitudeAtSeaLevel = metersPerSecondOfLatitudeAtSeaLevel * 60.0;
    public static double metersPerDegreeOfLatitudeAtSeaLevel = metersPerSecondOfLatitudeAtSeaLevel * 60.0 * 60.0;
    public static double metersPerSecondOfLongitudeAtSeaLevelAtEquator = 30.92;
    static final double averageRadius = 6367449.0;
    static final double equatorialRadius = 6378137.0;
    static final double polarRadius = 6356752.3;
    static final double equatorialRadius4 = Math.pow(6378137.0, 4.0);
    static final double polarRadius4 = Math.pow(6356752.3, 4.0);
    static final double _pi_div_180 = Math.PI / 180;
    static final double _180_div_pi = 57.29577951308232;

    public static double realMetersPerDegreeOfLongitudeAtSeaLevel(double degreesNorth) {
        CoordinateUtility.assertDegreeLatitude(degreesNorth);
        double radians = CoordinateUtility.toRadians(degreesNorth);
        assert (radians <= 1.5707963267948966);
        assert (radians >= -1.5707963267948966);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double nom = equatorialRadius4 * cos * cos + polarRadius4 * sin * sin;
        double denom = Math.pow(6378137.0 * cos, 2.0) + Math.pow(6356752.3 * sin, 2.0);
        double radiusAtLatitude = Math.sqrt(nom / denom);
        assert (radiusAtLatitude <= 6378137.0);
        assert (radiusAtLatitude >= 6356752.3);
        double lengthOfArc = Math.PI / 180 * Math.cos(radians) * radiusAtLatitude;
        return lengthOfArc;
    }

    public static CoordinateDD boundingBoxSouthWest(CoordinateDD start, double distance, ICoordinate.UNITS units) {
        double distanceAsMeters = CoordinateUtility.unitsToMeters(distance, units);
        double deltaNorthSouth = distanceAsMeters / metersPerDegreeOfLatitudeAtSeaLevel;
        Double currentLat = start.northSouth;
        Double deltaEastWest = 1.0 / (111320.0 * Math.cos(currentLat / 360.0 * 2.0 * Math.PI)) * distanceAsMeters;
        Double lon = start.eastWest - deltaEastWest;
        if (deltaEastWest < 360.0 && lon <= -180.0) {
            lon = 180.0 + lon % 180.0;
        }
        CoordinateDD ret = new CoordinateDD(start.northSouth - deltaNorthSouth, lon, true);
        return ret;
    }

    public static CoordinateDD boundingBoxNorthEast(CoordinateDD start, double distance, ICoordinate.UNITS units) {
        double distanceAsMeters = CoordinateUtility.unitsToMeters(distance, units);
        double deltaNorthSouth = distanceAsMeters / metersPerDegreeOfLatitudeAtSeaLevel;
        Double currentLat = start.northSouth;
        Double deltaEastWest = 1.0 / (111320.0 * Math.cos(currentLat / 360.0 * 2.0 * Math.PI)) * distanceAsMeters;
        Double lon = start.eastWest + deltaEastWest;
        if (deltaEastWest < 360.0 && lon >= 180.0) {
            lon = -180.0 + lon % 180.0;
        }
        CoordinateDD ret = new CoordinateDD(start.northSouth + deltaNorthSouth, lon, true);
        return ret;
    }

    public static void assertDegreeLatitude(double d) {
        if (d <= -90.0 || d > 90.0) {
            throw new IllegalArgumentException("" + d + " is not in [90:-90)");
        }
    }

    public static void assertDegreeLongitude(double d) {
        if (d <= -180.0 || d > 180.0) {
            throw new IllegalArgumentException("" + d + " is not in [180:-180)");
        }
    }

    public static double approxMetersPerDegreeOfLongitudeAtSeaLevel(double degreesNorth) {
        CoordinateUtility.assertDegreeLatitude(degreesNorth);
        double radians = CoordinateUtility.toRadians(degreesNorth);
        double lengthOfArc = Math.PI / 180 * Math.cos(radians) * 6367449.0;
        return lengthOfArc;
    }

    public static double toRadians(double degrees) {
        double radians = Math.PI / 180 * degrees;
        return radians;
    }

    public static double toDegrees(double radians) {
        double degrees = 57.29577951308232 * radians;
        return degrees;
    }

    public static double distance(CoordinateDD p1, CoordinateDD p2, ICoordinate.UNITS units) {
        double latP1 = p1.northSouth;
        double latP2 = p2.northSouth;
        double lonP1 = p1.eastWest;
        double lonP2 = p2.eastWest;
        if (latP1 == latP2 && lonP1 == lonP2) {
            return 0.0;
        }
        double distRad = Math.acos(Math.sin(CoordinateUtility.toRadians(latP1)) * Math.sin(CoordinateUtility.toRadians(latP2)) + Math.cos(CoordinateUtility.toRadians(latP1)) * Math.cos(CoordinateUtility.toRadians(latP2)) * Math.cos(CoordinateUtility.toRadians(lonP1 - lonP2)));
        double distAsDegree = CoordinateUtility.toDegrees(distRad);
        return CoordinateUtility.metersToUnits(distAsDegree * 60.0 * 1.1515 * 1609.344, units);
    }

    public static double distanceInMeters(double latP1, double latP2, double lonP1, double lonP2) {
        double distRad = Math.acos(Math.sin(CoordinateUtility.toRadians(latP1)) * Math.sin(CoordinateUtility.toRadians(latP2)) + Math.cos(CoordinateUtility.toRadians(latP1)) * Math.cos(CoordinateUtility.toRadians(latP2)) * Math.cos(CoordinateUtility.toRadians(lonP1 - lonP2)));
        double distAsDegree = CoordinateUtility.toDegrees(distRad);
        return distAsDegree * 60.0 * 1.1515 * 1609.344;
    }

    public static double metersToUnits(double meters, ICoordinate.UNITS units) {
        switch (units) {
            case Feet: {
                return meters * 3.2808399;
            }
            case Miles: {
                return meters / 1609.344;
            }
            case Meters: {
                return meters;
            }
            case Kilometers: {
                return meters / 1000.0;
            }
            case NauticalMiles: {
                return meters / 1852.0;
            }
        }
        throw new AssertionError((Object)("Unknown units: " + (Object)((Object)units)));
    }

    public static double unitsToMeters(double val, ICoordinate.UNITS units) {
        switch (units) {
            case Feet: {
                return val / 3.2808399;
            }
            case Miles: {
                return val * 1609.344;
            }
            case Meters: {
                return val;
            }
            case Kilometers: {
                return val * 1000.0;
            }
            case NauticalMiles: {
                return val * 1852.0;
            }
        }
        throw new AssertionError((Object)("Unknown units: " + (Object)((Object)units)));
    }

    public static double toDecimalDegrees(int degrees, int minutes, double seconds) {
        return (double)degrees + (double)minutes / 60.0 + seconds / 3600.0;
    }
}

