/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class CompareBOp
extends XSDBooleanIVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = 5661497748051783499L;
    private static final transient Logger log = Logger.getLogger(CompareBOp.class);

    public CompareBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right, Compare.CompareOp op) {
        this(new BOp[]{left, right}, NV.asMap(Annotations.OP, (Object)op));
    }

    public CompareBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null || this.getProperty(Annotations.OP) == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.toString());
        }
    }

    public CompareBOp(CompareBOp op) {
        super(op);
    }

    public Compare.CompareOp op() {
        return (Compare.CompareOp)this.getRequiredProperty(Annotations.OP);
    }

    public static boolean compare(IV<BigdataValue, ?> left, IV<BigdataValue, ?> right, Compare.CompareOp op) {
        if (log.isDebugEnabled()) {
            log.debug(left);
            log.debug(right);
        }
        if (left.isLiteral() && right.isLiteral()) {
            return CompareBOp.compareLiterals(left, right, op);
        }
        switch (op) {
            case EQ: {
                return CompareBOp.valuesEqual(left, right);
            }
            case NE: {
                return !CompareBOp.valuesEqual(left, right);
            }
        }
        throw new SparqlTypeErrorException();
    }

    private static boolean isRealTermId(IV iv) {
        return !iv.isInline() && !iv.isNullIV();
    }

    private static boolean compareLiterals(IV<BigdataValue, ?> left, IV<BigdataValue, ?> right, Compare.CompareOp op) {
        IV<BigdataURI, ?> rightDatatype;
        IV<BigdataURI, ?> leftDatatype;
        if (op == Compare.CompareOp.EQ && CompareBOp.isRealTermId(left) && CompareBOp.isRealTermId(right) && left.equals(right)) {
            return true;
        }
        if (left instanceof LiteralExtensionIV && right instanceof LiteralExtensionIV && (leftDatatype = ((LiteralExtensionIV)left).getExtensionIV()).equals(rightDatatype = ((LiteralExtensionIV)right).getExtensionIV())) {
            boolean accept = CompareBOp._accept(left.compareTo(right), op);
            if (log.isDebugEnabled()) {
                log.debug((Object)accept);
            }
            return accept;
        }
        Literal l1 = null;
        Literal l2 = null;
        if (left instanceof LiteralExtensionIV || right instanceof LiteralExtensionIV) {
            AbstractLiteralIV<BigdataLiteral, ?> delegate;
            boolean leftIsLiteralExtensionIV = left instanceof LiteralExtensionIV;
            AbstractLiteralIV<BigdataLiteral, ?> abstractLiteralIV = delegate = leftIsLiteralExtensionIV ? ((LiteralExtensionIV)left).getDelegate() : ((LiteralExtensionIV)right).getDelegate();
            if (delegate != null) {
                XSDIntegerIV delegateAsBuiltInLiteral = null;
                if (delegate instanceof PackedLongIV) {
                    PackedLongIV iv = (PackedLongIV)delegate;
                    delegateAsBuiltInLiteral = new XSDIntegerIV(iv.integerValue());
                }
                if (leftIsLiteralExtensionIV) {
                    l1 = delegateAsBuiltInLiteral;
                } else {
                    l2 = delegateAsBuiltInLiteral;
                }
            }
        }
        l1 = l1 == null ? CompareBOp.asLiteral(left) : l1;
        Literal literal = l2 = l2 == null ? CompareBOp.asLiteral(right) : l2;
        if (log.isDebugEnabled()) {
            log.debug((Object)l1);
            log.debug((Object)l2);
        }
        try {
            boolean accept = QueryEvaluationUtil.compareLiterals((Literal)l1, (Literal)l2, (Compare.CompareOp)op);
            if (log.isDebugEnabled()) {
                log.debug((Object)accept);
            }
            return accept;
        }
        catch (ValueExprEvaluationException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exception: " + (Object)((Object)ex)));
            }
            throw new SparqlTypeErrorException();
        }
    }

    private static boolean valuesEqual(IV<?, ?> left, IV<?, ?> right) {
        if (left.getVTE() != right.getVTE()) {
            return false;
        }
        if (left.isNullIV() || right.isNullIV()) {
            return CompareBOp.asValue(left).equals(CompareBOp.asValue(right));
        }
        return left.equals(right);
    }

    @Override
    public boolean accept(IBindingSet s) {
        IV left = (IV)this.get(0).get(s);
        IV right = (IV)this.get(1).get(s);
        if (left == null || right == null) {
            throw new SparqlTypeErrorException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("left: " + left));
            log.debug((Object)("right: " + right));
            log.debug((Object)("left value: " + (left.hasValue() ? left.getValue() : null)));
            log.debug((Object)("right value: " + (right.hasValue() ? right.getValue() : null)));
        }
        return CompareBOp.compare(left, right, this.op());
    }

    protected static boolean _accept(int compare, Compare.CompareOp op) {
        switch (op) {
            case EQ: {
                return compare == 0;
            }
            case NE: {
                return compare != 0;
            }
            case GT: {
                return compare > 0;
            }
            case GE: {
                return compare >= 0;
            }
            case LT: {
                return compare < 0;
            }
            case LE: {
                return compare <= 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String OP = CompareBOp.class.getName() + ".op";
    }
}

