/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IPrefixedURIHandler;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;

public class InlinePrefixedFixedWidthIntegerURIHandler
extends InlineLocalNameIntegerURIHandler
implements IPrefixedURIHandler {
    private String prefix = null;
    private int width = 0;

    public InlinePrefixedFixedWidthIntegerURIHandler(String namespace, String prefix, int width) {
        super(namespace);
        this.prefix = prefix;
        this.width = width;
    }

    public InlinePrefixedFixedWidthIntegerURIHandler(String namespace, String prefix, int width, int id) {
        super(namespace);
        this.prefix = prefix;
        this.width = width;
        this.packedId = id;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (!localName.startsWith(this.prefix)) {
            return null;
        }
        String intValue = this.getPackedValueString(localName.substring(this.prefix.length(), localName.length()));
        return super.createInlineIV(intValue);
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        String intStr = super.getLocalNameFromDelegate(delegate);
        int intVal = (int)this.getUnpackedValueFromString(intStr);
        String localName = this.prefix + String.format("%0" + this.width + "d", intVal);
        return localName;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }
}

