/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IPv4Address;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.PackedLongIV;
import org.openrdf.model.URI;

public enum DTEExtension {
    IPV4(0, 0, IPv4Address.class, XSD.IPV4, 0),
    PACKED_LONG(1, 0, Long.class, PackedLongIV.PACKED_LONG, 0),
    ARRAY(2, 0, Void.class, null, 0),
    MOCKED_IV(3, 0, Void.class, null, 0),
    RESERVED(-1, 0, Void.class, null, 0);

    final byte v;
    private final int len;
    private final Class<?> cls;
    private final URI datatypeURI;
    private final int flags;

    private DTEExtension(byte v, int len, Class<?> cls, URI datatypeURI, int flags) {
        this.v = v;
        this.len = len;
        this.cls = cls;
        this.datatypeURI = datatypeURI;
        this.flags = flags;
    }

    public static final DTEExtension valueOf(byte b) {
        switch (b) {
            case 0: {
                return IPV4;
            }
            case 1: {
                return PACKED_LONG;
            }
            case 2: {
                return ARRAY;
            }
            case 3: {
                return MOCKED_IV;
            }
        }
        throw new IllegalArgumentException(Byte.toString(b));
    }

    public static final DTEExtension valueOf(URI datatype) {
        if (datatype == null) {
            return null;
        }
        if (datatype.equals((Object)DTEExtension.IPV4.datatypeURI)) {
            return IPV4;
        }
        if (datatype.equals((Object)DTEExtension.PACKED_LONG.datatypeURI)) {
            return PACKED_LONG;
        }
        return null;
    }

    public final byte v() {
        return this.v;
    }

    public final int len() {
        return this.len;
    }

    public final Class<?> getCls() {
        return this.cls;
    }

    public final URI getDatatypeURI() {
        return this.datatypeURI;
    }
}

