/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.EdgeOnlyFilter;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.bd.BigdataGASState;
import com.bigdata.rdf.graph.impl.util.VertexDistribution;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.sail.Sail;

public class BigdataGASEngine
extends GASEngine {
    private static final Logger log = Logger.getLogger(GASEngine.class);

    public BigdataGASEngine(Sail sail, int nthreads) {
        this(((BigdataSail)sail).getIndexManager(), nthreads);
    }

    public BigdataGASEngine(IIndexManager indexManager, int nthreads) {
        super(nthreads);
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
    }

    public <VS, ES, ST> IGASState<VS, ES, ST> newGASState(IGraphAccessor graphAccessor, IGASProgram<VS, ES, ST> gasProgram) {
        IStaticFrontier frontier = this.newStaticFrontier();
        IGASSchedulerImpl gasScheduler = this.newScheduler();
        return new BigdataGASState<VS, ES, ST>((IGASEngine)this, (BigdataGraphAccessor)graphAccessor, frontier, gasScheduler, gasProgram);
    }

    public boolean getSortFrontier() {
        return true;
    }

    public static class BigdataGraphAccessor
    implements IGraphAccessor {
        private final IIndexManager indexManager;
        private final String namespace;
        private final long timestamp;
        private volatile WeakReference<AbstractTripleStore> kbRef;

        public BigdataGraphAccessor(IIndexManager indexManager, String namespace, long timestamp) {
            if (indexManager == null) {
                throw new IllegalArgumentException();
            }
            if (namespace == null) {
                throw new IllegalArgumentException();
            }
            this.indexManager = indexManager;
            this.namespace = namespace;
            this.timestamp = timestamp;
        }

        public BigdataGraphAccessor(IIndexManager indexManager) {
            this(indexManager, "kb", indexManager.getLastCommitTime());
        }

        public void advanceView() {
            if (this.timestamp == -1L) {
                this.kbRef = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractTripleStore getKB() {
            if (this.kbRef == null) {
                BigdataGraphAccessor bigdataGraphAccessor = this;
                synchronized (bigdataGraphAccessor) {
                    if (this.kbRef == null) {
                        this.kbRef = new WeakReference<AbstractTripleStore>(this.resolveKB());
                    }
                }
            }
            return (AbstractTripleStore)this.kbRef.get();
        }

        private AbstractTripleStore resolveKB() {
            AbstractTripleStore kb;
            long timestamp = this.timestamp;
            if (timestamp == -1L) {
                timestamp = this.indexManager.getLastCommitTime();
            }
            if ((kb = (AbstractTripleStore)this.indexManager.getResourceLocator().locate(this.namespace, timestamp)) == null) {
                throw new RuntimeException("Not found: namespace=" + this.namespace + ", timestamp=" + TimestampUtility.toString(timestamp));
            }
            return kb;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        private final SPOKeyOrder getKeyOrder(AbstractTripleStore kb, boolean inEdges) {
            SPOKeyOrder keyOrder = inEdges ? (kb.isQuads() ? SPOKeyOrder.OCSP : SPOKeyOrder.OSP) : (kb.isQuads() ? SPOKeyOrder.SPOC : SPOKeyOrder.SPO);
            return keyOrder;
        }

        private IStriterator getEdges(AbstractTripleStore kb, boolean inEdges, IGASContext<?, ?, ?> ctx, IV u) {
            return new AP(kb, inEdges, ctx, u).getEdges();
        }

        private long getEdgeCount(AbstractTripleStore kb, boolean inEdges, IGASContext<?, ?, ?> ctx, IV u) {
            return new AP(kb, inEdges, ctx, u).getEdgeCount();
        }

        public Iterator<Statement> getEdges(IGASContext<?, ?, ?> ctx, Value u, EdgesEnum edges) {
            AbstractTripleStore kb = this.getKB();
            switch (edges) {
                case NoEdges: {
                    return EmptyIterator.DEFAULT;
                }
                case InEdges: {
                    return this.getEdges(kb, true, ctx, this.getIV(u));
                }
                case OutEdges: {
                    return this.getEdges(kb, false, ctx, this.getIV(u));
                }
                case AllEdges: {
                    IStriterator a = this.getEdges(kb, true, ctx, this.getIV(u));
                    IStriterator b = this.getEdges(kb, false, ctx, this.getIV(u));
                    a.append((Iterator)b);
                    return a;
                }
            }
            throw new UnsupportedOperationException(edges.name());
        }

        private IV<?, ?> getIV(Value u) {
            if (u == null) {
                return null;
            }
            if (u instanceof IV) {
                return (IV)u;
            }
            if (u instanceof BigdataValue) {
                IV iv = ((BigdataValue)u).getIV();
                if (iv == null) {
                    throw new NotMaterializedException(u.toString());
                }
                return iv;
            }
            throw new RuntimeException("No IV: " + u);
        }

        public long getEdgeCount(IGASContext<?, ?, ?> ctx, Value u, EdgesEnum edges) {
            AbstractTripleStore kb = this.getKB();
            switch (edges) {
                case NoEdges: {
                    return 0L;
                }
                case InEdges: {
                    return this.getEdgeCount(kb, true, ctx, this.getIV(u));
                }
                case OutEdges: {
                    return this.getEdgeCount(kb, false, ctx, this.getIV(u));
                }
                case AllEdges: {
                    long a = this.getEdgeCount(kb, true, ctx, this.getIV(u));
                    long b = this.getEdgeCount(kb, false, ctx, this.getIV(u));
                    long n = a + b;
                    return n;
                }
            }
            throw new UnsupportedOperationException(edges.name());
        }

        public VertexDistribution getDistribution(Random r) {
            VertexDistribution sample = new VertexDistribution(r);
            ITupleIterator titr = this.getKB().getSPORelation().getPrimaryIndex().rangeIterator();
            while (titr.hasNext()) {
                ISPO spo = (ISPO)titr.next().getObject();
                if (!spo.o().isResource() || spo.s().equals(spo.o())) continue;
                sample.addOutEdgeSample((Resource)spo.s());
                sample.addInEdgeSample((Resource)spo.o());
            }
            return sample;
        }

        private IV[] getRandomSample(Random r, AbstractTripleStore kb, int desiredSampleSize) {
            int limit = (int)Math.min((long)desiredSampleSize * 3L, Integer.MAX_VALUE);
            HashSet<IV> samples = new HashSet<IV>();
            int round = 0;
            while (samples.size() < desiredSampleSize && round++ < limit) {
                IV iv = this.getRandomVertex(r, kb);
                samples.add(iv);
            }
            return samples.toArray(new IV[samples.size()]);
        }

        private IV getRandomVertex(Random r, AbstractTripleStore kb) {
            BTree ndx = (BTree)kb.getSPORelation().getPrimaryIndex();
            IV startingVertex = null;
            int size = (int)Math.min(ndx.rangeCount(), Integer.MAX_VALUE);
            while ((long)size > 0L && startingVertex == null) {
                Tuple tuple;
                int rindex = r.nextInt(size);
                if (ndx.valueAt(rindex, tuple = new Tuple(ndx, 3)) == null) continue;
                ISPO edge = (ISPO)ndx.getIndexMetadata().getTupleSerializer().deserialize(tuple);
                startingVertex = edge.s();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Starting vertex: " + startingVertex));
            }
            if (startingVertex == null) {
                throw new RuntimeException("No starting vertex: nedges=" + ndx.rangeCount());
            }
            return startingVertex;
        }

        private class AP {
            private final AbstractTripleStore kb;
            private final boolean inEdges;
            private final IGASContext<?, ?, ?> ctx;
            private final IV u;
            private final IV linkTypeIV;
            private final IV linkAttrTypeIV;
            private final boolean posOptimization;
            private final SPOKeyOrder keyOrder;
            private final IIndex ndx;
            private final byte[] fromKey;
            private final byte[] toKey;

            public AP(AbstractTripleStore kb, boolean inEdges, IGASContext<?, ?, ?> ctx, IV u) {
                IKeyBuilder keyBuilder;
                this.kb = kb;
                this.inEdges = inEdges;
                this.ctx = ctx;
                this.u = u;
                this.linkTypeIV = BigdataGraphAccessor.this.getIV((Value)ctx.getLinkType());
                this.linkAttrTypeIV = BigdataGraphAccessor.this.getIV((Value)ctx.getLinkAttributeType());
                boolean bl = this.posOptimization = this.linkTypeIV != null && this.linkAttrTypeIV == null && inEdges;
                if (this.posOptimization) {
                    this.keyOrder = kb.isQuads() ? SPOKeyOrder.POCS : SPOKeyOrder.POS;
                    this.ndx = kb.getSPORelation().getIndex(this.keyOrder);
                    keyBuilder = this.ndx.getIndexMetadata().getKeyBuilder();
                    keyBuilder.reset();
                    IVUtility.encode(keyBuilder, this.linkTypeIV);
                    IVUtility.encode(keyBuilder, u);
                } else if (!inEdges) {
                    this.keyOrder = BigdataGraphAccessor.this.getKeyOrder(kb, inEdges);
                    this.ndx = kb.getSPORelation().getIndex(this.keyOrder);
                    keyBuilder = this.ndx.getIndexMetadata().getKeyBuilder();
                    keyBuilder.reset();
                    if (this.linkAttrTypeIV != null) {
                        keyBuilder.appendSigned(SidIV.toFlags());
                    }
                    IVUtility.encode(keyBuilder, u);
                } else {
                    this.keyOrder = BigdataGraphAccessor.this.getKeyOrder(kb, inEdges);
                    this.ndx = kb.getSPORelation().getIndex(this.keyOrder);
                    keyBuilder = this.ndx.getIndexMetadata().getKeyBuilder();
                    keyBuilder.reset();
                    IVUtility.encode(keyBuilder, u);
                }
                this.fromKey = keyBuilder.getKey();
                this.toKey = SuccessorUtil.successor((byte[])this.fromKey.clone());
            }

            public long getEdgeCount() {
                long n = 0L;
                IStriterator sitr = this.getEdges();
                while (sitr.hasNext()) {
                    sitr.next();
                    ++n;
                }
                return n;
            }

            public IStriterator getEdges() {
                ITupleIterator titr = this.ndx.rangeIterator(this.fromKey, this.toKey, 0, 3, null);
                Striterator sitr = new Striterator((Iterator)titr);
                sitr.addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object e) {
                        ITuple t = (ITuple)e;
                        return t.getObject();
                    }
                });
                if (this.linkTypeIV != null && !this.posOptimization) {
                    if (this.linkAttrTypeIV == null) {
                        sitr.addFilter((IFilter)new Filter(){
                            private static final long serialVersionUID = 1L;

                            public boolean isValid(Object e) {
                                return ((ISPO)e).p().equals(AP.this.linkTypeIV);
                            }
                        });
                    } else {
                        sitr.addFilter((IFilter)new Filter(){
                            private static final long serialVersionUID = 1L;

                            public boolean isValid(Object e) {
                                SidIV subj = (SidIV)((ISPO)e).s();
                                ISPO linkAttr = subj.getInlineValue();
                                IV p = linkAttr.p();
                                boolean matched = p.equals(AP.this.linkTypeIV);
                                return matched;
                            }
                        });
                    }
                }
                if (this.linkAttrTypeIV != null) {
                    sitr.addFilter((IFilter)new Filter(){
                        private static final long serialVersionUID = 1L;

                        public boolean isValid(Object e) {
                            IV p = ((ISPO)e).p();
                            boolean matched = p.equals(AP.this.linkAttrTypeIV);
                            return matched;
                        }
                    });
                }
                if (this.linkTypeIV == null && this.linkAttrTypeIV == null) {
                    sitr.addFilter((IFilter)new EdgeOnlyFilter(this.ctx));
                }
                return sitr;
            }
        }
    }
}

