/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.concurrent.NamedLock;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.IResourceLockService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;

public final class ResourceLockService
implements IResourceLockService {
    private final NamedLock<String> locks = new NamedLock();

    @Override
    public IResourceLock acquireLock(String namespace) {
        Lock lock = this.locks.acquireLock(namespace);
        return new ResourceLock(lock);
    }

    @Override
    public IResourceLock acquireLock(String namespace, long timeout) throws InterruptedException, TimeoutException {
        Lock lock = this.locks.acquireLock(namespace, timeout, TimeUnit.MILLISECONDS);
        return new ResourceLock(lock);
    }

    private static final class ResourceLock
    implements IResourceLock {
        private final Lock lock;

        protected ResourceLock(Lock lock) {
            if (lock == null) {
                throw new IllegalArgumentException();
            }
            this.lock = lock;
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }
    }
}

