/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.BTree;
import com.bigdata.btree.DelegateBTree;
import com.bigdata.btree.ILinearList;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.UnisolatedReadWriteIndex;
import com.bigdata.journal.ICommitTimeEntry;
import com.bigdata.journal.IRootBlockView;
import java.util.concurrent.locks.Lock;

public class AbstractCommitTimeIndex<T extends ICommitTimeEntry>
extends DelegateBTree
implements ILinearList {
    private final BTree btree;

    private Tuple<T> getLookupTuple() {
        return this.btree.getLookupTuple();
    }

    protected AbstractCommitTimeIndex(BTree ndx) {
        super(new UnisolatedReadWriteIndex(ndx));
        this.btree = ndx;
    }

    public byte[] getKey(long commitTime) {
        return this.getIndexMetadata().getKeyBuilder().reset().append(commitTime).getKey();
    }

    public Lock readLock() {
        return this.btree.readLock();
    }

    public Lock writeLock() {
        return this.btree.writeLock();
    }

    public long getEntryCount() {
        return super.rangeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<T> valueAt(long index, Tuple<T> t) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            Tuple tuple = this.btree.valueAt(index, t);
            return tuple;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T find(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.readLock();
        lock.lock();
        try {
            long index = this.findIndexOf(timestamp);
            if (index == -1L) {
                T t = null;
                return t;
            }
            T t = this.valueAtIndex(index);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private T valueAtIndex(long index) {
        return (T)((ICommitTimeEntry)this.valueAt(index, this.getLookupTuple()).getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findNext(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.readLock();
        lock.lock();
        try {
            long index = this.findIndexOf(timestamp) + 1L;
            if (index == this.rangeCount()) {
                T t = null;
                return t;
            }
            T t = this.valueAtIndex(index);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public long findIndexOf(long commitTime) {
        if (commitTime < 0L) {
            throw new IllegalArgumentException();
        }
        long pos = this.indexOf(this.getKey(commitTime));
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                return -1L;
            }
            return --pos;
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T entry) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        long commitTime = entry.getCommitTime();
        if (commitTime == 0L) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.writeLock();
        lock.lock();
        try {
            byte[] key = this.getKey(commitTime);
            if (super.contains(key)) {
                throw new IllegalArgumentException("entry exists: timestamp=" + commitTime);
            }
            super.insert((Object)key, entry);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOldestEntry() {
        Lock lock = this.readLock();
        lock.lock();
        try {
            ICommitTimeEntry r;
            if (this.rangeCount() == 0L) {
                T t = null;
                return t;
            }
            Tuple<T> t = this.valueAt(0L, this.getLookupTuple());
            ICommitTimeEntry iCommitTimeEntry = r = (ICommitTimeEntry)t.getObject();
            return (T)iCommitTimeEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNewestEntry() {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long entryCount = this.getEntryCount();
            if (entryCount == 0L) {
                T t = null;
                return t;
            }
            ICommitTimeEntry iCommitTimeEntry = (ICommitTimeEntry)this.valueAt(entryCount - 1L, this.getLookupTuple()).getObject();
            return (T)iCommitTimeEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findByCommitCounter(long commitCounter) {
        if (commitCounter < 0L) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.readLock();
        lock.lock();
        try {
            ITupleIterator itr = this.rangeIterator(null, null, 0, 67, null);
            while (itr.hasNext()) {
                ITuple t = itr.next();
                ICommitTimeEntry r = (ICommitTimeEntry)t.getObject();
                IRootBlockView rb = r.getRootBlock();
                if (rb.getCommitCounter() > commitCounter) continue;
                ICommitTimeEntry iCommitTimeEntry = r;
                return (T)iCommitTimeEntry;
            }
            T t = null;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getEntryByReverseIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Lock lock = this.readLock();
        lock.lock();
        try {
            ICommitTimeEntry r;
            long entryCount = this.rangeCount();
            if (entryCount > Integer.MAX_VALUE) {
                throw new AssertionError();
            }
            int effectiveIndex = (int)entryCount - 1 - index;
            if (effectiveIndex < 0) {
                T t = null;
                return t;
            }
            Tuple<T> t = this.valueAt(effectiveIndex, this.getLookupTuple());
            ICommitTimeEntry iCommitTimeEntry = r = (ICommitTimeEntry)t.getObject();
            return (T)iCommitTimeEntry;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Lock lock = this.writeLock();
        lock.lock();
        try {
            this.btree.removeAll();
        }
        finally {
            lock.unlock();
        }
    }
}

