/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.ValueFormatter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;

public class TextValueFormatter
extends ValueFormatter {
    public TextValueFormatter(URLQueryModel model) {
        super(model);
    }

    @Override
    public String value(ICounter counter, Object val) {
        if (counter == null) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            return "N/A";
        }
        if (val instanceof Double || val instanceof Float) {
            NumberFormat fmt = this.decimalFormat;
            if (counter.getName().contains("%") || percent_pattern.matcher(counter.getName()).matches()) {
                fmt = this.percentFormat;
            }
            return fmt.format((Object)((Number)val).doubleValue());
        }
        if (val instanceof Long || val instanceof Integer) {
            NumberFormat fmt = this.integerFormat;
            return fmt.format((Object)((Number)val).longValue());
        }
        return val.toString();
    }

    @Override
    public void writeFullPath(Writer w, String path) throws IOException {
        this.writePath(w, path, 0);
    }

    @Override
    public void writePath(Writer w, String path, int rootDepth) throws IOException {
        String[] a = path.split("/");
        StringBuilder sb = new StringBuilder("/");
        for (int n = 1; n < a.length; ++n) {
            String name = a[n];
            if (n > 1) {
                if (n + 1 > rootDepth) {
                    w.write("/");
                }
                sb.append("/");
            }
            sb.append(name);
            if (n + 1 <= rootDepth) continue;
            if (rootDepth != 0 && n == rootDepth) {
                w.write("...");
                w.write("/");
            }
            w.write(name);
        }
    }
}

