/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeRange {
    public final Boolean relative;
    public final TimeUnit unit;
    public final long dur;
    protected static final Pattern pattern = Pattern.compile("([+-]?)([0-9]+)([mhd])");

    public long getAdjustedTimestamp(long ts) {
        long ms = this.unit.toMillis(this.dur);
        if (this.relative.booleanValue()) {
            return ms;
        }
        return ts - ms;
    }

    public TimeRange(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Matcher m = pattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(s);
        }
        this.relative = !"-".equals(m.group(1));
        char ch = m.group(2).charAt(0);
        switch (ch) {
            case 'm': {
                this.unit = TimeUnit.MINUTES;
                break;
            }
            case 'h': {
                this.unit = TimeUnit.HOURS;
                break;
            }
            case 'd': {
                this.unit = TimeUnit.DAYS;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.dur = Long.valueOf(m.group(1));
    }
}

