/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.query.CSet;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.QueryUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PivotTable {
    private static final Logger log = Logger.getLogger(PivotTable.class);
    public final HistoryTable src;
    public final ICounter[] a;
    public final LinkedHashSet<String> vcols;
    public final List<CSet> csets;
    public final String[] cnames;

    public PivotTable(Pattern pattern, String[] category, HistoryTable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        this.src = t;
        this.a = t.a;
        this.vcols = new LinkedHashSet();
        for (int i = 0; i < this.a.length; ++i) {
            this.vcols.add(this.a[i].getName());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("vnames: " + this.vcols));
        }
        AtomicInteger tmp = new AtomicInteger();
        this.csets = PivotTable.getCategoryValueSets(pattern, this.a, tmp);
        int ngroups = tmp.get();
        if (log.isInfoEnabled()) {
            log.info((Object)("csets: " + this.csets));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("ngroups=" + ngroups));
        }
        this.cnames = new String[ngroups];
        for (int i = 0; i < ngroups; ++i) {
            this.cnames[i] = category != null && category.length > i ? category[i] : "group#" + i;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("category names=" + Arrays.toString(this.cnames)));
        }
        for (int row = 0; row < t.nrows; ++row) {
            long timestamp = t.getTimestamp(row);
            for (CSet cset : this.csets) {
                assert (cset.cats.length == this.cnames.length) : "cset categories=" + Arrays.toString(cset.cats) + " vs " + "category names: " + Arrays.toString(this.cnames);
                Double[] vals = new Double[this.vcols.size()];
                int ndefined = 0;
                int valueColumnIndex = 0;
                for (String vcol : this.vcols) {
                    int valueCountForColumn = 0;
                    double val = 0.0;
                    block5: for (ICounter c : cset.counters) {
                        if (!c.getName().equals(vcol)) continue;
                        for (int col = 0; col < this.a.length; ++col) {
                            IHistoryEntry e;
                            if (c != this.a[col] || (e = t.data[row][col]) == null) continue;
                            val += ((Number)e.getValue()).doubleValue();
                            ++valueCountForColumn;
                            continue block5;
                        }
                    }
                    if (valueCountForColumn > 0) {
                        vals[valueColumnIndex] = val;
                        ++ndefined;
                    }
                    if (log.isDebugEnabled() && valueCountForColumn > 0) {
                        log.debug((Object)("vcol=" + vcol + ", vcol#=" + valueColumnIndex + ", #values=" + valueCountForColumn + ", val=" + val));
                    }
                    ++valueColumnIndex;
                }
                if (ndefined != 0) continue;
            }
        }
    }

    protected static List<CSet> getCategoryValueSets(Pattern pattern, ICounter[] a, AtomicInteger ngroups) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        String[][] sets = new String[a.length][];
        int usedGroupCount = 0;
        for (int i = 0; i < a.length; ++i) {
            ICounter c = a[i];
            if (a[i] == null) {
                throw new IllegalArgumentException();
            }
            String[] groups = QueryUtil.getCapturedGroups(pattern, c);
            int n = groups.length;
            if (n > 0 && c.getName().equals(groups[n - 1])) {
                sets[i] = new String[n - 1];
                System.arraycopy(groups, 0, sets[i], 0, n - 1);
                usedGroupCount = Math.max(usedGroupCount, n - 1);
                continue;
            }
            sets[i] = groups;
            usedGroupCount = Math.max(usedGroupCount, n);
        }
        ngroups.set(usedGroupCount);
        LinkedList<CSet> csets = new LinkedList<CSet>();
        for (int i = 0; i < sets.length; ++i) {
            String[] set = sets[i];
            if (set == null) continue;
            CSet cset = new CSet(set, a[i]);
            csets.add(cset);
            for (int j = i + 1; j < sets.length; ++j) {
                String[] oset = sets[j];
                if (oset == null) continue;
                assert (oset.length == set.length);
                boolean same = true;
                for (int k = 0; k < set.length && same; ++k) {
                    if (set[k].equals(oset[k])) continue;
                    same = false;
                }
                if (!same) continue;
                sets[j] = null;
                cset.add(a[j]);
            }
        }
        return csets;
    }

    class PivotRow {
        final int row;
        final long timestamp;
        final CSet cset;
        final Double[] values;

        PivotRow(int row, long timestamp, CSet cset, Double[] values) {
            if (cset == null) {
                throw new IllegalArgumentException();
            }
            if (cset.cats.length != PivotTable.this.cnames.length) {
                throw new IllegalArgumentException();
            }
            if (values == null) {
                throw new IllegalArgumentException();
            }
            if (values.length != PivotTable.this.vcols.size()) {
                throw new IllegalArgumentException();
            }
            this.row = row;
            this.timestamp = timestamp;
            this.cset = cset;
            this.values = values;
        }
    }
}

