/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.DeadlockException;
import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.concurrent.TxDag;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.AbstractTask;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.concurrent.WriteTaskCounters;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class NonBlockingLockManager<R extends Comparable<R>> {
    protected static final Logger log = Logger.getLogger(NonBlockingLockManager.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final ConcurrentWeakValueCacheWithTimeout<R, ResourceQueue<LockFutureTask<? extends Object>>> resourceQueues = new ConcurrentWeakValueCacheWithTimeout(1000, TimeUnit.SECONDS.toNanos(60L));
    private final boolean predeclareLocks;
    private final boolean sortLockRequests;
    protected final TxDag waitsFor;
    protected final Executor delegate;
    private CounterSet root;
    final Counters counters = new Counters();
    private final ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(this.getClass().getName()));
    private volatile RunState runState = RunState.Starting;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition stateChanged = this.lock.newCondition();
    private final BlockingQueue<LockFutureTask<? extends Object>> acceptedTasks = new LinkedBlockingQueue<LockFutureTask<? extends Object>>();
    private final BlockingQueue<LockFutureTask<? extends Object>> waitingTasks = new LinkedBlockingQueue<LockFutureTask<? extends Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseLocksForTask(R[] resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (resource.length == 0) {
            return;
        }
        this.lock.lock();
        try {
            LockFutureTask task = null;
            for (R r : resource) {
                ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(r);
                if (!(task == null ? (task = (LockFutureTask)resourceQueue.queue.peek()) == null : task != resourceQueue.queue.peek())) continue;
                throw new IllegalArgumentException("Task does not hold declared lock: " + r);
            }
            if (task == null) {
                throw new AssertionError();
            }
            boolean waiting = false;
            this.releaseLocks(task, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized CounterSet getCounters() {
        if (this.root == null) {
            this.root = new CounterSet();
            this.root.addCounter("naccepted", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.naccepted);
                }
            });
            this.root.addCounter("nrejected", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nrejected);
                }
            });
            this.root.addCounter("nstarted", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nstarted);
                }
            });
            this.root.addCounter("nended", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nended);
                }
            });
            this.root.addCounter("ncancel", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.ncancel);
                }
            });
            this.root.addCounter("nerror", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nerror);
                }
            });
            this.root.addCounter("ndeadlock", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.ndeadlock);
                }
            });
            this.root.addCounter("ntimeout", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.ntimeout);
                }
            });
            this.root.addCounter("nwaiting", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nwaiting);
                }
            });
            this.root.addCounter("nrunning", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.nrunning);
                }
            });
            this.root.addCounter("maxRunning", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.counters.maxRunning);
                }
            });
            this.root.addCounter("nresourceQueues", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.resourceQueues.size());
                }
            });
            this.root.addCounter("runState", new Instrument<String>(){

                @Override
                public void sample() {
                    this.setValue(NonBlockingLockManager.this.runState.toString());
                }
            });
            this.root.addCounter("queues", new Instrument<String>(){

                @Override
                public void sample() {
                    Iterator itr = NonBlockingLockManager.this.resourceQueues.entryIterator();
                    LinkedList<ResourceQueueSize> list = new LinkedList<ResourceQueueSize>();
                    while (itr.hasNext()) {
                        Map.Entry entry = (Map.Entry)itr.next();
                        WeakReference queueRef = (WeakReference)entry.getValue();
                        ResourceQueue queue = (ResourceQueue)queueRef.get();
                        if (queue == null) continue;
                        list.add(new ResourceQueueSize(queue));
                    }
                    Object[] a = list.toArray();
                    Arrays.sort(a);
                    StringBuilder sb = new StringBuilder();
                    for (Object t : a) {
                        sb.append(t.toString());
                        sb.append(" ");
                    }
                    this.setValue(sb.toString());
                }
            });
        }
        return this.root;
    }

    public NonBlockingLockManager(int maxConcurrency, boolean predeclareLocks, Executor delegate) {
        this(maxConcurrency, predeclareLocks, true, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NonBlockingLockManager(int maxConcurrency, boolean predeclareLocks, boolean sortLockRequests, Executor delegate) {
        if (maxConcurrency < 2 && !predeclareLocks) {
            throw new IllegalArgumentException("maxConcurrency: must be 2+ unless you are predeclaring locks, not " + maxConcurrency);
        }
        if (predeclareLocks && !sortLockRequests) {
            throw new IllegalArgumentException("Sorting of lock requests MUST be enabled when locks are being predeclared.");
        }
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.predeclareLocks = predeclareLocks;
        this.sortLockRequests = sortLockRequests;
        this.waitsFor = predeclareLocks ? null : new TxDag(maxConcurrency);
        this.delegate = delegate;
        this.service.submit(new AcceptTask());
        this.lock.lock();
        try {
            this.setRunState(RunState.Running);
        }
        finally {
            this.lock.unlock();
        }
    }

    private ResourceQueue<LockFutureTask<? extends Object>> declareResource(R resource) {
        ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(resource);
        resourceQueue = new ResourceQueue(this, resource);
        ResourceQueue oldval = (ResourceQueue)this.resourceQueues.putIfAbsent(resource, (Object)resourceQueue);
        if (oldval != null) {
            return oldval;
        }
        return resourceQueue;
    }

    public <T> Future<T> submit(R[] resource, Callable<T> task) {
        return this.submit((Comparable[])resource, task, TimeUnit.SECONDS, Long.MAX_VALUE, 1);
    }

    public <T> Future<T> submit(R[] resource, Callable<T> task, TimeUnit unit, long lockTimeout, int maxLockTries) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        for (R r : resource) {
            if (r != null) continue;
            throw new IllegalArgumentException();
        }
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (maxLockTries <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] a = (Comparable[])resource.clone();
        if (this.sortLockRequests) {
            Arrays.sort(a);
        }
        this.lock.lock();
        try {
            switch (this.runState) {
                case Running: {
                    LockFutureTask future = new LockFutureTask(this, (Comparable[])a, task, lockTimeout, maxLockTries);
                    try {
                        this.acceptedTasks.add(future);
                        ++this.counters.naccepted;
                    }
                    catch (IllegalStateException ex) {
                        ++this.counters.nrejected;
                        throw new RejectedExecutionException(ex);
                    }
                    this.stateChanged.signal();
                    LockFutureTask lockFutureTask = future;
                    return lockFutureTask;
                }
            }
            ++this.counters.nrejected;
            throw new RejectedExecutionException("runState=" + (Object)((Object)this.runState));
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isOpen() {
        return this.runState == RunState.Running;
    }

    public boolean isShutdown() {
        switch (this.runState) {
            case Shutdown: 
            case ShutdownNow: 
            case Halted: {
                return true;
            }
        }
        return false;
    }

    public boolean isTerminated() {
        return this.runState == RunState.Halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.runState.val < RunState.Shutdown.val) {
                this.setRunState(RunState.Shutdown);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.lock.lock();
        try {
            if (this.runState.val < RunState.ShutdownNow.val) {
                this.setRunState(RunState.ShutdownNow);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void setRunState(RunState newval) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!this.runState.isTransitionLegal(newval)) {
            throw new IllegalStateException("runState=" + (Object)((Object)this.runState) + ", but newValue=" + (Object)((Object)newval));
        }
        if (this.runState != newval) {
            if (INFO) {
                log.info((Object)("Set runState=" + (Object)((Object)newval)));
            }
            this.runState = newval;
            this.stateChanged.signal();
        }
    }

    private <T> void requestLocks(LockFutureTask<T> task) throws DeadlockException {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        switch (this.runState) {
            case ShutdownNow: 
            case Halted: {
                throw new IllegalStateException("runState=" + (Object)((Object)this.runState));
            }
        }
        if (((LockFutureTask)task).resource.length == 0) {
            return;
        }
        if (this.predeclareLocks && !((LockFutureTask)task).lockedResources.isEmpty()) {
            throw new IllegalStateException("Operation already has lock(s): " + task);
        }
        if (DEBUG) {
            log.debug((Object)("Acquiring lock(s): " + Arrays.toString(((LockFutureTask)task).resource)));
        }
        if (this.waitsFor != null) {
            ResourceQueue<LockFutureTask<Object>> resourceQueue;
            LinkedHashSet predecessors = new LinkedHashSet();
            for (Comparable r : ((LockFutureTask)task).resource) {
                resourceQueue = this.declareResource(r);
                if (resourceQueue.queue.isEmpty()) continue;
                predecessors.addAll(resourceQueue.queue);
            }
            if (!predecessors.isEmpty()) {
                this.waitsFor.addEdges(task, predecessors.toArray());
            }
            for (Comparable r : ((LockFutureTask)task).resource) {
                resourceQueue = this.declareResource(r);
                resourceQueue.queue.add(task);
                ((LockFutureTask)task).lockedResources.add(resourceQueue);
            }
        } else {
            for (Comparable r : ((LockFutureTask)task).resource) {
                ResourceQueue<LockFutureTask<Object>> resourceQueue = this.declareResource(r);
                resourceQueue.queue.add(task);
                ((LockFutureTask)task).lockedResources.add(resourceQueue);
            }
        }
    }

    private boolean holdsAllLocks(LockFutureTask<? extends Object> task) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        for (Comparable r : ((LockFutureTask)task).resource) {
            ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get((Object)r);
            assert (resourceQueue != null) : "resource=" + r;
            if (resourceQueue.isGranted(task)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void releaseLocks(LockFutureTask<T> t, boolean waiting) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (DEBUG) {
            log.debug((Object)("Releasing locks: " + t));
        }
        try {
            Iterator itr = ((LockFutureTask)t).lockedResources.iterator();
            while (itr.hasNext()) {
                ResourceQueue resourceQueue = (ResourceQueue)itr.next();
                if (!resourceQueue.queue.remove(t)) {
                    log.error((Object)("Lock request not found: resource=" + resourceQueue.getResource() + ", task=" + t));
                }
                itr.remove();
            }
        }
        finally {
            if (this.waitsFor != null) {
                TxDag txDag = this.waitsFor;
                synchronized (txDag) {
                    try {
                        this.waitsFor.removeEdges(t, waiting);
                        if (this.waitsFor.releaseVertex(t)) {
                            log.error((Object)("No vertex? " + t));
                        }
                    }
                    catch (Throwable t2) {
                        log.error((Object)this, t2);
                    }
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "{ accepted=" + this.acceptedTasks.size() + ", waiting=" + this.waitingTasks.size() + ", #started=" + this.counters.nstarted + ", #ended=" + this.counters.nended + ", #cancel=" + this.counters.ncancel + ", #timeout=" + this.counters.ntimeout + ", #error=" + this.counters.nerror + ", #deadlock=" + this.counters.ndeadlock + (this.waitsFor != null ? ", vertices=" + this.waitsFor.size() : "") + "}";
    }

    static /* synthetic */ void access$900(NonBlockingLockManager x0, RunState x1) {
        x0.setRunState(x1);
    }

    protected static class ResourceQueue<T extends LockFutureTask<? extends Object>> {
        private final R resource;
        final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
        final /* synthetic */ NonBlockingLockManager this$0;

        public R getResource() {
            return this.resource;
        }

        public boolean isLocked() {
            return !this.queue.isEmpty();
        }

        public int getQueueSize() {
            return Math.max(0, this.queue.size() - 1);
        }

        public boolean isGranted(T tx) {
            if (tx == null) {
                throw new IllegalArgumentException();
            }
            return this.queue.peek() == tx;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{resource=" + this.resource + ", queue=" + this.queue.toString() + "}";
        }

        public ResourceQueue(R resource) {
            this.this$0 = var1_1;
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            this.resource = resource;
        }
    }

    private class AcceptTask
    implements Runnable {
        private AcceptTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block13: while (true) {
                switch (15.$SwitchMap$com$bigdata$concurrent$NonBlockingLockManager$RunState[NonBlockingLockManager.access$100(NonBlockingLockManager.this).ordinal()]) {
                    case 2: {
                        this.awaitStateChange(RunState.Starting);
                        continue block13;
                    }
lbl6:
                    // 2 sources

                    case 1: {
                        do {
                            if (this.processAcceptedTasks()) ** GOTO lbl6
                        } while (this.processWaitingTasks());
                        this.awaitStateChange(RunState.Running);
                        continue block13;
                    }
lbl12:
                    // 2 sources

                    case 3: {
                        do {
                            if (this.processAcceptedTasks()) ** GOTO lbl12
                        } while (this.processWaitingTasks());
                        NonBlockingLockManager.access$300(NonBlockingLockManager.this).lock();
                        try {
                            if (!NonBlockingLockManager.access$600(NonBlockingLockManager.this).isEmpty() || !NonBlockingLockManager.access$700(NonBlockingLockManager.this).isEmpty()) ** GOTO lbl28
                            if (NonBlockingLockManager.INFO) {
                                NonBlockingLockManager.log.info((Object)"No more work.");
                            }
                            if (RunState.access$800(NonBlockingLockManager.access$100(NonBlockingLockManager.this)) < RunState.access$800(RunState.ShutdownNow)) {
                                NonBlockingLockManager.access$900(NonBlockingLockManager.this, RunState.ShutdownNow);
                                continue block13;
                            }
                        }
                        finally {
                            NonBlockingLockManager.access$300(NonBlockingLockManager.this).unlock();
                            continue block13;
                        }
lbl28:
                        // 2 sources

                        this.awaitStateChange(RunState.Shutdown);
                        continue block13;
                    }
                    case 4: {
                        if (NonBlockingLockManager.INFO) {
                            NonBlockingLockManager.log.info((Object)NonBlockingLockManager.access$100(NonBlockingLockManager.this));
                        }
                        this.cancelTasks(NonBlockingLockManager.access$600(NonBlockingLockManager.this).iterator(), false);
                        this.cancelTasks(NonBlockingLockManager.access$700(NonBlockingLockManager.this).iterator(), false);
                        NonBlockingLockManager.access$300(NonBlockingLockManager.this).lock();
                        try {
                            if (RunState.access$800(NonBlockingLockManager.access$100(NonBlockingLockManager.this)) < RunState.access$800(RunState.Halted)) {
                                NonBlockingLockManager.access$900(NonBlockingLockManager.this, RunState.Halted);
                            }
                        }
                        finally {
                            NonBlockingLockManager.access$300(NonBlockingLockManager.this).unlock();
                        }
                    }
                    case 5: {
                        if (NonBlockingLockManager.INFO) {
                            NonBlockingLockManager.log.info((Object)NonBlockingLockManager.access$100(NonBlockingLockManager.this));
                        }
                        return;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitStateChange(RunState expected) {
            NonBlockingLockManager.this.lock.lock();
            try {
                if (NonBlockingLockManager.this.runState != expected) {
                    return;
                }
                if (!NonBlockingLockManager.this.acceptedTasks.isEmpty() || !NonBlockingLockManager.this.waitingTasks.isEmpty()) {
                    return;
                }
                if (INFO) {
                    log.info((Object)"Waiting...");
                }
                NonBlockingLockManager.this.stateChanged.await();
                if (INFO) {
                    log.info((Object)"Woke up...");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                NonBlockingLockManager.this.lock.unlock();
            }
        }

        private void cancelTasks(Iterator<LockFutureTask<? extends Object>> itr, boolean mayInterruptIfRunning) {
            while (itr.hasNext()) {
                LockFutureTask<? extends Object> t = itr.next();
                t.cancel(mayInterruptIfRunning);
                itr.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processAcceptedTasks() {
            int nmoved = 0;
            Iterator itr = NonBlockingLockManager.this.acceptedTasks.iterator();
            while (itr.hasNext()) {
                LockFutureTask t = (LockFutureTask)itr.next();
                if (t.isCancelled()) {
                    itr.remove();
                    continue;
                }
                if (t.isTimeout()) {
                    t.setException(new TimeoutException());
                    ++NonBlockingLockManager.this.counters.ntimeout;
                    itr.remove();
                    continue;
                }
                int nvertices = -1;
                NonBlockingLockManager.this.lock.lock();
                try {
                    if (NonBlockingLockManager.this.waitsFor != null) {
                        nvertices = NonBlockingLockManager.this.waitsFor.size();
                    }
                    if (NonBlockingLockManager.this.waitsFor != null && NonBlockingLockManager.this.waitsFor.isFull()) {
                        if (INFO) {
                            log.info((Object)"Maximum multi-programming capacity.");
                        }
                        boolean bl = nmoved > 0;
                        return bl;
                    }
                    t.ntries++;
                    if (NonBlockingLockManager.this.waitsFor != null) {
                        NonBlockingLockManager.this.waitsFor.lookup(t, true);
                    }
                    NonBlockingLockManager.this.requestLocks(t);
                }
                catch (Throwable t2) {
                    int nafter;
                    t.setException(t2);
                    if (NonBlockingLockManager.this.waitsFor != null && nvertices != (nafter = NonBlockingLockManager.this.waitsFor.size())) {
                        throw new AssertionError((Object)("#vertices: before=" + nvertices + ", after=" + nafter));
                    }
                    if (t2 instanceof DeadlockException) {
                        log.warn((Object)("Deadlock: " + this + ", task=" + t));
                        ++NonBlockingLockManager.this.counters.ndeadlock;
                        if (t.ntries < t.maxLockTries) {
                            log.warn((Object)("Will retry task: " + t));
                            continue;
                        }
                        log.error((Object)("Deadlock not resolved: " + this + ", task=" + t));
                    } else {
                        log.error((Object)("Internal error: task=" + t), t2);
                    }
                    itr.remove();
                }
                finally {
                    NonBlockingLockManager.this.lock.unlock();
                    continue;
                }
                NonBlockingLockManager.this.waitingTasks.add(t);
                ++NonBlockingLockManager.this.counters.nwaiting;
                ++nmoved;
                itr.remove();
                if (!DEBUG) continue;
                log.debug((Object)("Waiting: " + t));
            }
            if (INFO && nmoved > 0) {
                log.info((Object)("#moved=" + nmoved));
            }
            return nmoved > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processWaitingTasks() {
            Iterator itr = NonBlockingLockManager.this.waitingTasks.iterator();
            int nstarted = 0;
            while (itr.hasNext()) {
                boolean holdsLocks;
                LockFutureTask t = (LockFutureTask)itr.next();
                if (t.isCancelled()) {
                    itr.remove();
                    continue;
                }
                if (t.isTimeout()) {
                    t.setException(new TimeoutException());
                    itr.remove();
                    ++NonBlockingLockManager.this.counters.ntimeout;
                    continue;
                }
                NonBlockingLockManager.this.lock.lock();
                try {
                    holdsLocks = NonBlockingLockManager.this.holdsAllLocks(t);
                }
                finally {
                    NonBlockingLockManager.this.lock.unlock();
                }
                if (!holdsLocks) continue;
                if (INFO) {
                    log.info((Object)("Executing: " + t));
                }
                try {
                    assert (!NonBlockingLockManager.this.lock.isHeldByCurrentThread());
                    NonBlockingLockManager.this.delegate.execute(t);
                }
                catch (RejectedExecutionException t2) {
                    if (INFO) {
                        log.info((Object)"Delegate is busy.");
                    }
                    return nstarted > 0;
                }
                itr.remove();
                ++nstarted;
            }
            if (INFO && nstarted > 0) {
                log.info((Object)("#started=" + nstarted));
            }
            return nstarted > 0;
        }
    }

    protected class LockFutureTask<T>
    extends FutureTaskMon<T> {
        private final R[] resource;
        private final long lockTimeout;
        private final int maxLockTries;
        private int ntries;
        private final long acceptTime;
        private final LinkedHashSet<ResourceQueue<LockFutureTask<? extends Object>>> lockedResources;
        private final Object task;
        private long nanoTime_lockLatency;
        final /* synthetic */ NonBlockingLockManager this$0;

        protected boolean isTimeout() {
            return System.nanoTime() - this.acceptTime >= this.lockTimeout;
        }

        @Override
        public String toString() {
            return super.toString() + "{resources=" + Arrays.toString(this.resource) + ", done=" + this.isDone() + ", cancelled=" + this.isCancelled() + ", ntries=" + this.ntries + "}";
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LockFutureTask(R[] timeout, Callable<T> callable, long maxLockTries, int n) {
            void resource;
            this.this$0 = (NonBlockingLockManager)l;
            super(task);
            this.ntries = 0;
            this.acceptTime = System.nanoTime();
            this.lockedResources = new LinkedHashSet();
            this.resource = resource;
            this.lockTimeout = (long)timeout;
            this.maxLockTries = (int)maxLockTries;
            this.task = task;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LockFutureTask(R[] val, Runnable timeout, T t, long maxLockTries, int n) {
            void resources;
            this.this$0 = (NonBlockingLockManager)l;
            super((Runnable)task, val);
            this.ntries = 0;
            this.acceptTime = System.nanoTime();
            this.lockedResources = new LinkedHashSet();
            this.resource = resources;
            this.lockTimeout = (long)timeout;
            this.maxLockTries = (int)maxLockTries;
            this.task = task;
        }

        public R[] getResource() {
            return this.resource;
        }

        public long getLockLatency() {
            return this.nanoTime_lockLatency;
        }

        public int getMaxLockTries() {
            return this.maxLockTries;
        }

        public long getLockTimeout() {
            return this.lockTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            this.this$0.lock.lock();
            try {
                if (DEBUG) {
                    log.debug((Object)("Exception: " + this + ", cause=" + t), t);
                }
                ++this.this$0.counters.nerror;
                boolean waiting = true;
                this.this$0.releaseLocks(this, true);
                this.this$0.stateChanged.signal();
            }
            finally {
                this.this$0.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean ret = super.cancel(mayInterruptIfRunning);
            this.this$0.lock.lock();
            try {
                if (DEBUG) {
                    log.debug((Object)("Cancelled: " + this));
                }
                ++this.this$0.counters.ncancel;
                boolean waiting = true;
                this.this$0.releaseLocks(this, true);
                this.this$0.stateChanged.signal();
            }
            finally {
                this.this$0.lock.unlock();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.task instanceof AbstractTask && ((AbstractTask)this.task).getTaskCounters() instanceof WriteTaskCounters) {
                long lockWaitingTime = System.nanoTime() - this.acceptTime;
                ((WriteTaskCounters)((AbstractTask)this.task).getTaskCounters()).lockWaitingNanoTime.addAndGet(lockWaitingTime);
            }
            Counters lockWaitingTime = this.this$0.counters;
            synchronized (lockWaitingTime) {
                ++this.this$0.counters.nstarted;
                --this.this$0.counters.nwaiting;
                ++this.this$0.counters.nrunning;
                if (this.this$0.counters.nrunning > this.this$0.counters.maxRunning) {
                    this.this$0.counters.maxRunning = this.this$0.counters.nrunning;
                }
            }
            try {
                if (DEBUG) {
                    log.debug((Object)("Running: " + this));
                }
                super.run();
            }
            finally {
                this.this$0.lock.lock();
                try {
                    if (DEBUG) {
                        log.debug((Object)("Did run: " + this));
                    }
                    lockWaitingTime = this.this$0.counters;
                    synchronized (lockWaitingTime) {
                        ++this.this$0.counters.nended;
                        --this.this$0.counters.nrunning;
                    }
                    boolean waiting = false;
                    this.this$0.releaseLocks(this, false);
                    this.this$0.stateChanged.signal();
                }
                finally {
                    this.this$0.lock.unlock();
                }
            }
        }
    }

    protected static class Counters {
        public long naccepted;
        public long nrejected;
        public long nstarted;
        public long nended;
        public long ncancel;
        public long nerror;
        public long ndeadlock;
        public long ntimeout;
        public int nwaiting;
        public int nrunning;
        public int maxRunning;

        protected Counters() {
        }
    }

    private class ResourceQueueSize
    implements Comparable<ResourceQueueSize> {
        final R resource;
        int size;

        public ResourceQueueSize(ResourceQueue<LockFutureTask<? extends Object>> queue) {
            this.resource = queue.getResource();
            this.size = queue.getQueueSize();
        }

        @Override
        public int compareTo(ResourceQueueSize arg0) {
            return arg0.size - this.size;
        }

        public String toString() {
            return "(" + this.resource + "," + this.size + ")";
        }
    }

    public static enum RunState {
        Starting(0),
        Running(1),
        Shutdown(2),
        ShutdownNow(3),
        Halted(4);

        private final int val;

        private RunState(int val) {
            this.val = val;
        }

        public int value() {
            return this.val;
        }

        public boolean isTransitionLegal(RunState newval) {
            if (this == Starting) {
                if (newval == Running) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == Running) {
                if (newval == Shutdown) {
                    return true;
                }
                if (newval == ShutdownNow) {
                    return true;
                }
            } else if (this == Shutdown) {
                if (newval == ShutdownNow) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == ShutdownNow && newval == Halted) {
                return true;
            }
            return false;
        }
    }
}

