/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IndexSegmentCheckpoint;
import com.bigdata.btree.IndexSegmentRegion;
import com.bigdata.rawstore.WormAddressManager;

public class IndexSegmentAddressManager
extends WormAddressManager {
    protected final long offsetLeaves;
    protected final long extentLeaves;
    protected final long offsetNodes;
    protected final long extentNodes;
    protected final long offsetBlobs;
    protected final long extentBlobs;
    protected final long maxOffset;

    public IndexSegmentAddressManager(IndexSegmentCheckpoint checkpoint) {
        super(checkpoint.offsetBits);
        this.offsetLeaves = checkpoint.offsetLeaves;
        this.extentLeaves = checkpoint.extentLeaves;
        this.offsetNodes = checkpoint.offsetNodes;
        this.extentNodes = checkpoint.extentNodes;
        this.offsetBlobs = checkpoint.offsetBlobs;
        this.extentBlobs = checkpoint.extentBlobs;
        this.maxOffset = checkpoint.length;
    }

    public final IndexSegmentRegion getRegion(long addr) {
        long encodedOffset = super.getOffset(addr);
        IndexSegmentRegion region = IndexSegmentRegion.decodeRegion(encodedOffset);
        return region;
    }

    @Override
    public final long getOffset(long addr) {
        long offset;
        if (addr == 0L) {
            return 0L;
        }
        long encodedOffset = super.getOffset(addr);
        IndexSegmentRegion region = IndexSegmentRegion.decodeRegion(encodedOffset);
        int nbytes = this.getByteCount(addr);
        long decodedOffset = IndexSegmentRegion.decodeOffset(encodedOffset);
        switch (region) {
            case BASE: {
                offset = decodedOffset;
                if (decodedOffset + (long)nbytes > this.maxOffset) {
                    throw new AssertionError((Object)("Region=" + (Object)((Object)region) + ", addr=" + this.toString(addr) + ", offset=" + offset + ", byteCount=" + nbytes + ", maxOffset=" + this.maxOffset));
                }
                break;
            }
            case NODE: {
                offset = decodedOffset + this.offsetNodes;
                if (decodedOffset + (long)nbytes > this.extentNodes) {
                    throw new AssertionError((Object)("Region=" + (Object)((Object)region) + ", addr=" + this.toString(addr) + ", offset=" + offset + ", byteCount=" + nbytes + ", sizeNodes=" + this.extentNodes));
                }
                break;
            }
            case BLOB: {
                offset = decodedOffset + this.offsetBlobs;
                if (decodedOffset + (long)nbytes > this.extentBlobs) {
                    throw new AssertionError((Object)("Region=" + (Object)((Object)region) + ", addr=" + this.toString(addr) + ", offset=" + offset + ", byteCount=" + nbytes + ", sizeBlobs=" + this.extentBlobs));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not decode: addr=" + addr);
            }
        }
        return offset;
    }

    @Override
    public String toString(long addr) {
        if (addr == 0L) {
            return "NULL";
        }
        long encodedOffset = super.getOffset(addr);
        int nbytes = this.getByteCount(addr);
        return "{region=" + (Object)((Object)IndexSegmentRegion.decodeRegion(encodedOffset)) + ",off=" + IndexSegmentRegion.decodeOffset(encodedOffset) + ",len=" + nbytes + "}";
    }

    public boolean isNodeAddr(long addr) {
        long offset = this.getOffset(addr);
        int length = this.getByteCount(addr);
        boolean isNodeAddr = offset >= this.offsetNodes && offset + (long)length <= this.offsetNodes + this.extentNodes;
        return isNodeAddr;
    }

    public boolean isLeafAddr(long addr) {
        long offset = this.getOffset(addr);
        int length = this.getByteCount(addr);
        boolean isNodeAddr = offset >= this.offsetLeaves && offset + (long)length <= this.offsetLeaves + this.extentLeaves;
        return isNodeAddr;
    }
}

