/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IRawRecordAccess;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rawstore.IBlock;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class AbstractTuple<E>
implements ITuple<E> {
    protected final int flags;
    protected final boolean needKeys;
    protected final boolean needVals;
    private final DataOutputBuffer kbuf;
    private DataInputBuffer keyStream = null;
    private DataInputBuffer valStream = null;
    private final DataOutputBuffer vbuf;
    private boolean isNull;
    private long versionTimestamp = 0L;
    private boolean versionDeleted = false;
    private int nvisited = 0;

    @Override
    public final int flags() {
        return this.flags;
    }

    @Override
    public final boolean getKeysRequested() {
        return this.needKeys;
    }

    @Override
    public final boolean getValuesRequested() {
        return this.needVals;
    }

    @Override
    public final ByteArrayBuffer getKeyBuffer() {
        if (!this.needKeys) {
            throw new UnsupportedOperationException();
        }
        return this.kbuf;
    }

    @Override
    public final DataInputBuffer getKeyStream() {
        if (!this.needKeys) {
            throw new UnsupportedOperationException();
        }
        if (this.keyStream == null) {
            this.keyStream = new DataInputBuffer(this.kbuf.array(), 0, this.kbuf.limit());
        } else {
            this.keyStream.setBuffer(this.kbuf.array(), 0, this.kbuf.limit());
        }
        return this.keyStream;
    }

    @Override
    public final DataInputBuffer getValueStream() {
        if (!this.needVals) {
            throw new UnsupportedOperationException();
        }
        if (this.isNull) {
            throw new UnsupportedOperationException();
        }
        if (this.versionDeleted) {
            throw new UnsupportedOperationException();
        }
        if (this.valStream == null) {
            this.valStream = new DataInputBuffer(this.vbuf.array(), 0, this.vbuf.limit());
        } else {
            this.valStream.setBuffer(this.vbuf.array(), 0, this.vbuf.limit());
        }
        return this.valStream;
    }

    @Override
    public long getVisitCount() {
        return this.nvisited;
    }

    private AbstractTuple() {
        throw new UnsupportedOperationException();
    }

    public AbstractTuple(int flags) {
        this.flags = flags;
        this.needKeys = (flags & 1) != 0;
        this.needVals = (flags & 2) != 0;
        this.kbuf = this.needKeys ? new DataOutputBuffer(128) : null;
        this.vbuf = this.needVals ? new DataOutputBuffer(128) : null;
    }

    @Override
    public final byte[] getKey() {
        if (!this.needKeys) {
            throw new UnsupportedOperationException();
        }
        return this.kbuf.toByteArray();
    }

    @Override
    public final boolean isNull() {
        return this.isNull;
    }

    @Override
    public final byte[] getValue() {
        if (!this.needVals) {
            throw new UnsupportedOperationException();
        }
        if (this.versionDeleted || this.isNull) {
            return null;
        }
        return this.vbuf.toByteArray();
    }

    @Override
    public final ByteArrayBuffer getValueBuffer() {
        if (this.versionDeleted) {
            throw new UnsupportedOperationException();
        }
        if (this.isNull) {
            throw new UnsupportedOperationException();
        }
        return this.vbuf;
    }

    @Override
    public final E getObject() {
        if (this.versionDeleted) {
            return null;
        }
        return (E)this.getTupleSerializer().deserialize(this);
    }

    @Override
    public final long getVersionTimestamp() {
        return this.versionTimestamp;
    }

    @Override
    public final boolean isDeletedVersion() {
        return this.versionDeleted;
    }

    @Override
    public IBlock readBlock(long addr) {
        throw new UnsupportedOperationException();
    }

    public void copy(int index, ILeafData leaf) {
        ++this.nvisited;
        this.versionDeleted = leaf.hasDeleteMarkers() && leaf.getDeleteMarker(index);
        long l = this.versionTimestamp = leaf.hasVersionTimestamps() ? leaf.getVersionTimestamp(index) : 0L;
        if (this.needKeys) {
            this.kbuf.reset();
            leaf.getKeys().copy(index, this.kbuf);
        }
        if (this.needVals) {
            this.vbuf.reset();
            if (!this.versionDeleted) {
                this.isNull = leaf.getValues().isNull(index);
                if (!this.isNull) {
                    if (leaf.hasRawRecords()) {
                        long addr = leaf.getRawRecord(index);
                        if (addr == 0L) {
                            leaf.getValues().copy(index, this.vbuf);
                        } else {
                            ByteBuffer tmp = ((IRawRecordAccess)((Object)leaf)).readRawRecord(addr);
                            this.vbuf.copy(tmp);
                        }
                    } else {
                        leaf.getValues().copy(index, this.vbuf);
                    }
                }
            }
        }
    }

    public void copyTuple(byte[] key, byte[] val) {
        this.copyTuple(key, val, false, 0L);
    }

    public void copyTuple(byte[] key, byte[] val, boolean deleted, long timestamp) {
        ++this.nvisited;
        this.versionDeleted = deleted;
        this.versionTimestamp = timestamp;
        if (this.needKeys) {
            this.kbuf.reset();
            this.kbuf.put(key);
        }
        if (this.needVals) {
            this.vbuf.reset();
            if (!this.versionDeleted) {
                boolean bl = this.isNull = val == null;
                if (!this.isNull) {
                    this.vbuf.put(val);
                }
            }
        }
    }

    public void copyTuple(ITuple t) {
        ++this.nvisited;
        this.versionDeleted = t.isDeletedVersion();
        this.versionTimestamp = t.getVersionTimestamp();
        if (this.needKeys) {
            this.kbuf.reset().copyAll(t.getKeyBuffer());
        }
        if (this.needVals) {
            this.vbuf.reset();
            if (!this.versionDeleted) {
                this.isNull = t.isNull();
                if (!this.isNull) {
                    this.vbuf.reset().copyAll(t.getValueBuffer());
                }
            }
        }
    }

    protected void clear() {
        this.versionDeleted = false;
        this.versionTimestamp = 0L;
        if (this.kbuf != null) {
            this.kbuf.reset();
        }
        if (this.vbuf != null) {
            this.vbuf.reset();
        }
        this.isNull = true;
    }

    void markDeleted() {
        this.versionDeleted = true;
        this.versionTimestamp = 0L;
        if (this.vbuf != null) {
            this.vbuf.reset();
        }
        this.isNull = true;
    }

    public String toString() {
        return AbstractTuple.toString(this);
    }

    public static String toString(ITuple tuple) {
        Object obj;
        try {
            obj = tuple.getObject();
        }
        catch (UnsupportedOperationException ex) {
            obj = "N/A";
        }
        catch (Throwable t) {
            obj = t.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tuple.getClass().getName() + "@" + tuple.hashCode());
        sb.append("{ nvisited=" + tuple.getVisitCount());
        sb.append(", flags=" + AbstractTuple.flagString(tuple.flags()));
        if (tuple.isDeletedVersion()) {
            sb.append(", deleted");
        }
        if (tuple.getVersionTimestamp() != 0L) {
            sb.append(", timestamp=" + tuple.getVersionTimestamp());
        }
        sb.append(", key=" + (tuple.getKeysRequested() ? Arrays.toString(tuple.getKey()) : "N/A"));
        sb.append(", val=" + (tuple.getValuesRequested() ? (tuple.isNull() ? "null" : Arrays.toString(tuple.getValue())) : "N/A"));
        sb.append(", obj=" + (obj instanceof byte[] ? Arrays.toString((byte[])obj) : obj));
        sb.append(", sourceIndex=" + tuple.getSourceIndex());
        sb.append("}");
        return sb.toString();
    }

    public static String flagString(int flags) {
        StringBuilder sb = new StringBuilder();
        int onCount = 0;
        sb.append("[");
        if ((flags & 1) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("KEYS");
        }
        if ((flags & 2) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("VALS");
        }
        if ((flags & 4) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("DELETED");
        }
        if ((flags & 8) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("READONLY");
        }
        if ((flags & 0x10) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("REMOVEALL");
        }
        if ((flags & 0x20) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("CURSOR");
        }
        if ((flags & 0x40) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("REVERSE");
        }
        if ((flags & 0x80) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("FIXED_LENGTH_SUCCESSOR");
        }
        if ((flags & 0x100) != 0) {
            if (onCount++ > 0) {
                sb.append(",");
            }
            sb.append("PARALLEL");
        }
        sb.append("]");
        return sb.toString();
    }
}

