/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.aggregate;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.MathUtility;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import java.util.Map;
import org.openrdf.model.Literal;

public class SUM
extends AggregateBase<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 1L;
    private transient NumericIV aggregated = ZERO;
    private transient Throwable firstCause = null;

    public SUM(SUM op) {
        super(op);
    }

    public SUM(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public SUM(boolean distinct, IValueExpression ... expr) {
        super(distinct, expr);
    }

    @Override
    public synchronized void reset() {
        this.aggregated = ZERO;
        this.firstCause = null;
    }

    @Override
    public synchronized IV done() {
        if (this.firstCause != null) {
            throw new RuntimeException(this.firstCause);
        }
        return this.aggregated;
    }

    @Override
    public synchronized IV get(IBindingSet bindingSet) {
        try {
            return this.doGet(bindingSet);
        }
        catch (Throwable t) {
            if (this.firstCause == null) {
                this.firstCause = t;
            }
            throw new RuntimeException(t);
        }
    }

    private IV doGet(IBindingSet bindingSet) {
        int arity = this.arity();
        for (int i = 0; i < arity; ++i) {
            IValueExpression expr = (IValueExpression)this.get(i);
            IV iv = (IV)expr.get(bindingSet);
            if (iv == null) continue;
            Literal lit = IVValueExpression.asLiteral(iv);
            if (!MathUtility.checkNumericDatatype(lit)) {
                throw new SparqlTypeErrorException();
            }
            this.aggregated = MathUtility.literalMath(this.aggregated, lit, MathBOp.MathOp.PLUS);
        }
        return this.aggregated;
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }
}

