/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.controller;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.util.concurrent.IHaltable;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;

public abstract class AbstractSubqueryOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public int getMaxParallelSubqueries() {
        return this.getProperty(Annotations.MAX_PARALLEL_SUBQUERIES, Integer.MAX_VALUE);
    }

    public AbstractSubqueryOp(AbstractSubqueryOp op) {
        super(op);
    }

    public AbstractSubqueryOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        BOp[] subqueries = (BOp[])this.getRequiredProperty(Annotations.SUBQUERIES);
        if (subqueries.length == 0) {
            throw new IllegalArgumentException(Annotations.SUBQUERIES);
        }
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ControllerTask(this, context));
    }

    private static class ControllerTask
    implements Callable<Void> {
        private final AbstractSubqueryOp controllerOp;
        private final BOp[] subqueries;
        private final BOpContext<IBindingSet> context;
        private final int nparallel;
        private final Executor executor;

        public ControllerTask(AbstractSubqueryOp controllerOp, BOpContext<IBindingSet> context) {
            if (controllerOp == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.controllerOp = controllerOp;
            this.context = context;
            this.subqueries = (BOp[])controllerOp.getRequiredProperty(Annotations.SUBQUERIES);
            this.nparallel = controllerOp.getProperty(Annotations.MAX_PARALLEL_SUBQUERIES, Integer.MAX_VALUE);
            this.executor = new LatchedExecutor(context.getIndexManager().getExecutorService(), this.nparallel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> source = this.context.getSource();
            try {
                while (source.hasNext()) {
                    IBindingSet[] chunk;
                    for (IBindingSet bset : chunk = (IBindingSet[])source.next()) {
                        this.consumeBindingSet(bset);
                    }
                }
                this.context.getSink().flush();
                Void void_ = null;
                return void_;
            }
            finally {
                source.close();
                this.context.getSink().close();
                if (this.context.getSink2() != null) {
                    this.context.getSink2().close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void consumeBindingSet(IBindingSet bset) throws InterruptedException, ExecutionException {
            LinkedList<1> tasks = new LinkedList<1>();
            try {
                final CountDownLatch latch = new CountDownLatch(this.subqueries.length);
                for (BOp op : this.subqueries) {
                    tasks.add(new FutureTask<IRunningQuery>((Callable)new SubqueryTask(op, this.context, bset)){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                super.run();
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                for (FutureTask futureTask : tasks) {
                    this.executor.execute(futureTask);
                }
                latch.await();
                for (FutureTask futureTask : tasks) {
                    futureTask.get();
                }
            }
            finally {
                for (FutureTask futureTask : tasks) {
                    futureTask.cancel(true);
                }
            }
        }

        static /* synthetic */ BOpContext access$000(ControllerTask x0) {
            return x0.context;
        }

        private class SubqueryTask
        implements Callable<IRunningQuery> {
            private final BOpContext<IBindingSet> parentContext;
            private final BOp subQueryOp;
            private final IBindingSet bset;

            public SubqueryTask(BOp subQuery, BOpContext<IBindingSet> parentContext, IBindingSet bset) {
                this.subQueryOp = subQuery;
                this.parentContext = parentContext;
                this.bset = bset;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRunningQuery call() throws Exception {
                IHaltable runningSubquery = null;
                try (ICloseableIterator<IBindingSet[]> subquerySolutionItr = null;){
                    QueryEngine queryEngine = this.parentContext.getRunningQuery().getQueryEngine();
                    runningSubquery = queryEngine.eval(this.subQueryOp, this.bset);
                    subquerySolutionItr = runningSubquery.iterator();
                    BOpUtility.copy(subquerySolutionItr, this.parentContext.getSink(), null, null, null, null, null);
                    runningSubquery.get();
                    IHaltable iHaltable = runningSubquery;
                    return iHaltable;
                }
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String SUBQUERIES = AbstractSubqueryOp.class.getName() + ".subqueries";
        public static final String MAX_PARALLEL_SUBQUERIES = AbstractSubqueryOp.class.getName() + ".maxParallelSubqueries";
        public static final int DEFAULT_MAX_PARALLEL_SUBQUERIES = Integer.MAX_VALUE;
    }
}

