/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.xml.sax.Locator;

public class RDFParserException
extends OWLRuntimeException {
    protected final String publicId;
    protected final String systemId;
    protected final int lineNumber;
    protected final int columnNumber;

    public RDFParserException(String message, Locator locator) {
        this(null, message, locator);
    }

    public RDFParserException(@Nullable Exception e, String message, Locator locator) {
        super(RDFParserException.message(locator, message), e);
        this.publicId = locator.getPublicId();
        this.systemId = locator.getSystemId();
        this.lineNumber = locator.getLineNumber();
        this.columnNumber = locator.getColumnNumber();
    }

    private static String message(Locator locator, String message) {
        int lineNumber = locator.getLineNumber();
        int columnNumber = locator.getColumnNumber();
        if (lineNumber == -1 && columnNumber == -1) {
            return message;
        }
        return "[line=" + lineNumber + ':' + "column=" + columnNumber + "] " + message;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

