/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.expression;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.model.AsOWLAnnotationProperty;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AsOWLDataProperty;
import org.semanticweb.owlapi.model.AsOWLDatatype;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ShortFormEntityChecker
implements OWLEntityChecker {
    private final BidirectionalShortFormProvider shortFormProvider;

    public ShortFormEntityChecker(BidirectionalShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
    }

    @Override
    @Nullable
    public OWLClass getOWLClass(String name) {
        return this.find(name, AsOWLClass::isOWLClass, AsOWLClass::asOWLClass);
    }

    @Override
    @Nullable
    public OWLDataProperty getOWLDataProperty(String name) {
        return this.find(name, AsOWLDataProperty::isOWLDataProperty, AsOWLDataProperty::asOWLDataProperty);
    }

    @Override
    @Nullable
    public OWLDatatype getOWLDatatype(String name) {
        return this.find(name, AsOWLDatatype::isOWLDatatype, AsOWLDatatype::asOWLDatatype);
    }

    @Override
    @Nullable
    public OWLNamedIndividual getOWLIndividual(String name) {
        return this.find(name, AsOWLNamedIndividual::isOWLNamedIndividual, AsOWLNamedIndividual::asOWLNamedIndividual);
    }

    @Override
    @Nullable
    public OWLObjectProperty getOWLObjectProperty(String name) {
        return this.find(name, AsOWLObjectProperty::isOWLObjectProperty, AsOWLObjectProperty::asOWLObjectProperty);
    }

    @Override
    @Nullable
    public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
        return this.find(name, AsOWLAnnotationProperty::isOWLAnnotationProperty, AsOWLAnnotationProperty::asOWLAnnotationProperty);
    }

    @Nullable
    protected <T extends OWLEntity> T find(String name, Predicate<OWLEntity> p, Function<OWLEntity, T> f) {
        OWLAPIPreconditions.checkNotNull(name, "name cannot be null");
        Optional<OWLEntity> findFirst = this.shortFormProvider.entities(name).filter(p).findFirst();
        if (findFirst.isPresent()) {
            return (T)((OWLEntity)f.apply(findFirst.get()));
        }
        return null;
    }
}

