/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.FrameStructureException;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class Frame {
    protected Collection<Clause> clauses = new ArrayList<Clause>();
    @Nullable
    protected String id;
    @Nullable
    protected FrameType type;

    public Frame() {
        this(null);
    }

    public Frame(@Nullable FrameType type) {
        this.type = type;
    }

    public void freeze() {
        if (this.clauses.isEmpty()) {
            this.clauses = Collections.emptyList();
            return;
        }
        for (Clause clause : this.clauses) {
            clause.freeze();
        }
        if (this.clauses.size() == 1) {
            this.clauses = Collections.singletonList(this.clauses.iterator().next());
            return;
        }
        if (this.clauses instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)this.clauses;
            arrayList.trimToSize();
        }
    }

    @Nullable
    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<Clause> getClauses() {
        return this.clauses;
    }

    public void setClauses(Collection<Clause> clauses) {
        this.clauses = clauses;
    }

    public List<Clause> getClauses(@Nullable String tag) {
        ArrayList<Clause> cls = new ArrayList<Clause>();
        if (tag == null) {
            return cls;
        }
        for (Clause cl : this.clauses) {
            if (!tag.equals(cl.getTag())) continue;
            cls.add(cl);
        }
        return cls;
    }

    public List<Clause> getClauses(OBOFormatConstants.OboFormatTag tag) {
        return this.getClauses(tag.getTag());
    }

    @Nullable
    public Clause getClause(@Nullable String tag) {
        if (tag == null) {
            return null;
        }
        for (Clause cl : this.clauses) {
            if (!tag.equals(cl.getTag())) continue;
            return cl;
        }
        return null;
    }

    @Nullable
    public Clause getClause(OBOFormatConstants.OboFormatTag tag) {
        return this.getClause(tag.getTag());
    }

    public void addClause(Clause cl) {
        if (!(this.clauses instanceof ArrayList)) {
            ArrayList<Clause> tmp = new ArrayList<Clause>(this.clauses.size() + 1);
            tmp.addAll(this.clauses);
            this.clauses = tmp;
        }
        this.clauses.add(cl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Frame(");
        sb.append(this.id);
        sb.append(' ');
        this.clauses.forEach(cl -> sb.append(cl).append(' '));
        sb.append(')');
        return sb.toString();
    }

    @Nullable
    public Object getTagValue(String tag) {
        Clause clause = this.getClause(tag);
        if (clause == null) {
            return null;
        }
        return clause.getValue();
    }

    @Nullable
    public Object getTagValue(OBOFormatConstants.OboFormatTag tag) {
        return this.getTagValue(tag.getTag());
    }

    @Nullable
    public <T> T getTagValue(String tag, Class<T> cls) {
        Clause clause = this.getClause(tag);
        if (clause == null) {
            return null;
        }
        Object value = clause.getValue();
        if (value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    @Nullable
    public <T> T getTagValue(OBOFormatConstants.OboFormatTag tag, Class<T> cls) {
        return this.getTagValue(tag.getTag(), cls);
    }

    public Collection<Object> getTagValues(OBOFormatConstants.OboFormatTag tag) {
        return this.getTagValues(tag.getTag());
    }

    public Collection<Object> getTagValues(String tag) {
        ArrayList<Object> vals = new ArrayList<Object>();
        this.getClauses(tag).forEach(v -> vals.add(v.getValue()));
        return vals;
    }

    public <T> Collection<T> getTagValues(OBOFormatConstants.OboFormatTag tag, Class<T> cls) {
        return this.getTagValues(tag.getTag(), cls);
    }

    public <T> Collection<T> getTagValues(String tag, Class<T> cls) {
        ArrayList vals = new ArrayList();
        this.getClauses(tag).forEach(c -> vals.add(c.getValue(cls)));
        return vals;
    }

    public Collection<Xref> getTagXrefs(String tag) {
        ArrayList<Xref> xrefs = new ArrayList<Xref>();
        Clause clause = this.getClause(tag);
        if (clause != null) {
            for (Object ob : clause.getValues()) {
                if (!(ob instanceof Xref)) continue;
                xrefs.add((Xref)ob);
            }
        }
        return xrefs;
    }

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        this.getClauses().forEach(cl -> tags.add(cl.getTag()));
        return tags;
    }

    private boolean sameID(Frame f) {
        if (this.id == null) {
            return f.getId() == null;
        }
        return OWLAPIPreconditions.verifyNotNull(this.id).equals(f.getId());
    }

    private boolean sameType(Frame f) {
        if (this.type == null) {
            return f.getType() == null;
        }
        return OWLAPIPreconditions.verifyNotNull(this.type).equals((Object)f.getType());
    }

    public void merge(Frame extFrame) throws FrameMergeException {
        if (this == extFrame) {
            return;
        }
        if (!this.sameID(extFrame)) {
            throw new FrameMergeException("ids do not match");
        }
        if (!this.sameType(extFrame)) {
            throw new FrameMergeException("frame types do not match");
        }
        extFrame.getClauses().forEach(this::addClause);
    }

    public void check() {
        List<Clause> iClauses;
        if (FrameType.HEADER.equals((Object)this.type)) {
            this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION, OBOFormatConstants.OboFormatTag.TAG_DATE, OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_SAVED_BY, OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY);
        }
        if (FrameType.TYPEDEF.equals((Object)this.type)) {
            this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_DOMAIN, OBOFormatConstants.OboFormatTag.TAG_RANGE, OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG, OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG);
        }
        if (!FrameType.HEADER.equals((Object)this.getType())) {
            List<Clause> tagIdClauses = this.getClauses(OBOFormatConstants.OboFormatTag.TAG_ID);
            if (tagIdClauses.size() != 1) {
                throw new FrameStructureException(this, "cardinality of id field must be 1");
            }
            tagIdClauses.get(0).getValue();
            if (this.getId() == null) {
                throw new FrameStructureException(this, "id field must be set");
            }
        }
        if ((iClauses = this.getClauses(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF)).size() == 1) {
            throw new FrameStructureException(this, "single intersection_of tags are not allowed");
        }
        this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS, OBOFormatConstants.OboFormatTag.TAG_NAME, OBOFormatConstants.OboFormatTag.TAG_DEF, OBOFormatConstants.OboFormatTag.TAG_COMMENT, OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE, OBOFormatConstants.OboFormatTag.TAG_CREATED_BY, OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE);
    }

    private void checkMaxOneCardinality(OBOFormatConstants.OboFormatTag ... tags) {
        for (OBOFormatConstants.OboFormatTag tag : tags) {
            if (this.getClauses(tag).size() <= 1) continue;
            throw new FrameStructureException(this, "multiple " + tag.getTag() + " tags not allowed.");
        }
    }

    public static enum FrameType {
        HEADER,
        TERM,
        TYPEDEF,
        INSTANCE,
        ANNOTATION;

    }
}

