/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.arq.querybuilder.rewriters.ElementRewriter;
import org.apache.jena.arq.querybuilder.rewriters.NodeValueRewriter;
import org.apache.jena.arq.querybuilder.rewriters.OpRewriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;

public class ExprRewriter
extends AbstractRewriter<Expr>
implements ExprVisitor {
    public ExprRewriter(Map<Var, Node> values) {
        super(values);
    }

    public void visit(ExprFunction0 func) {
        this.push(func);
    }

    public void visit(ExprFunction1 func) {
        func.getArg().visit((ExprVisitor)this);
        this.push(func.copy((Expr)this.pop()));
    }

    public void visit(ExprFunction2 func) {
        func.getArg2().visit((ExprVisitor)this);
        func.getArg1().visit((ExprVisitor)this);
        this.push(func.copy((Expr)this.pop(), (Expr)this.pop()));
    }

    public void visit(ExprFunction3 func) {
        func.getArg3().visit((ExprVisitor)this);
        func.getArg2().visit((ExprVisitor)this);
        func.getArg1().visit((ExprVisitor)this);
        this.push(func.copy((Expr)this.pop(), (Expr)this.pop(), (Expr)this.pop()));
    }

    public void visit(ExprFunctionN func) {
        ExprList exprList = this.rewrite(new ExprList(func.getArgs()));
        ExprFunctionN retval = (ExprFunctionN)func.deepCopy();
        ExprRewriter.setExprList(retval, exprList);
        this.push(retval);
    }

    private static void setExprList(ExprFunctionN n, ExprList exprList) {
        try {
            Field f = ExprFunctionN.class.getDeclaredField("args");
            f.setAccessible(true);
            f.set(n, exprList);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public void visit(ExprFunctionOp funcOp) {
        ElementRewriter elementRewriter = new ElementRewriter(this.values);
        funcOp.getElement().visit((ElementVisitor)elementRewriter);
        OpRewriter opRewriter = new OpRewriter(this.values);
        funcOp.getGraphPattern().visit((OpVisitor)opRewriter);
        try {
            Constructor<?> con = funcOp.getClass().getConstructor(Element.class, Op.class);
            this.push((Expr)con.newInstance(elementRewriter.pop(), opRewriter.pop()));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void visit(NodeValue nv) {
        NodeValueRewriter rewriter = new NodeValueRewriter(this.values);
        nv.visit((NodeValueVisitor)rewriter);
        this.push((Expr)rewriter.pop());
    }

    public void visit(ExprNone none) {
        throw new InternalErrorException("Visit Expr.NONE");
    }

    public void visit(ExprVar nv) {
        Node n = this.changeNode((Node)nv.asVar());
        if (n.isVariable()) {
            this.push(new ExprVar(n));
        } else {
            this.push(NodeValue.makeNode((Node)n));
        }
    }

    public void visit(ExprTripleTerm tripleTerm) {
        Triple t1 = tripleTerm.getTriple();
        Triple t2 = this.rewrite(t1);
        Node ntt = NodeFactory.createTripleNode((Triple)t2);
        this.push(ExprLib.nodeToExpr((Node)ntt));
    }

    public void visit(ExprAggregator eAgg) {
        Node n = this.changeNode((Node)eAgg.getVar());
        if (n.equals((Object)eAgg.getVar())) {
            this.push(eAgg);
        } else {
            this.push(NodeValue.makeNode((Node)n));
        }
    }

    public final List<SortCondition> rewriteSortConditionList(List<SortCondition> lst) {
        if (lst == null) {
            return null;
        }
        ArrayList<SortCondition> retval = new ArrayList<SortCondition>();
        for (SortCondition sc : lst) {
            retval.add(this.rewrite(sc));
        }
        return retval;
    }

    public final SortCondition rewrite(SortCondition sortCondition) {
        sortCondition.getExpression().visit((ExprVisitor)this);
        return new SortCondition((Expr)this.pop(), sortCondition.getDirection());
    }

    public final ExprList rewrite(ExprList lst) {
        if (lst == null) {
            return null;
        }
        ExprList exprList = new ExprList();
        int limit = lst.size();
        for (int i = 0; i < limit; ++i) {
            lst.get(i).visit((ExprVisitor)this);
            exprList.add((Expr)this.pop());
        }
        return exprList;
    }
}

