/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.arq.querybuilder.rewriters.ExprRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.sparql.lang.sparql_11.SPARQLParser11;

public class SolutionModifierHandler
implements Handler {
    private final Query query;

    public SolutionModifierHandler(Query query) {
        this.query = query;
    }

    public void addAll(SolutionModifierHandler solutionModifier) {
        List lst = solutionModifier.query.getOrderBy();
        if (lst != null) {
            for (SortCondition sc : lst) {
                this.query.addOrderBy(sc);
            }
        }
        this.query.getGroupBy().addAll(solutionModifier.query.getGroupBy());
        this.query.getHavingExprs().addAll(solutionModifier.query.getHavingExprs());
        this.query.setLimit(solutionModifier.query.getLimit());
        this.query.setOffset(solutionModifier.query.getOffset());
    }

    public void addOrderBy(SortCondition condition) {
        this.query.addOrderBy(condition);
    }

    public void addOrderBy(Expr expr) {
        this.query.addOrderBy(expr, -2);
    }

    public void addOrderBy(Expr expr, Order order) {
        this.query.addOrderBy(expr, order == Order.ASCENDING ? 1 : -1);
    }

    public void addOrderBy(Var var) {
        this.query.addOrderBy((Node)var, -2);
    }

    public void addOrderBy(Var var, Order order) {
        this.query.addOrderBy((Node)var, order == Order.ASCENDING ? 1 : -1);
    }

    public void addGroupBy(Expr expr) {
        this.query.addGroupBy(expr);
    }

    public void addGroupBy(Var var) {
        this.query.addGroupBy((Node)var);
    }

    public void addGroupBy(Var var, Expr expr) {
        this.query.addGroupBy(var, expr);
    }

    public void addHaving(String expression) throws ParseException {
        String havingClause = "HAVING (" + expression + " )";
        SPARQLParser11 parser = new SPARQLParser11((InputStream)new ByteArrayInputStream(havingClause.getBytes()));
        parser.setQuery(this.query);
        parser.HavingClause();
    }

    public void addHaving(Var var) {
        this.query.addHavingCondition((Expr)new ExprVar(var));
    }

    public void addHaving(Expr expr) {
        this.query.addHavingCondition(expr);
    }

    public void setLimit(int limit) {
        this.query.setLimit(limit < 1 ? Long.MIN_VALUE : (long)limit);
    }

    public void setOffset(int offset) {
        this.query.setOffset(offset < 1 ? Long.MIN_VALUE : (long)offset);
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        if (values.isEmpty()) {
            return;
        }
        ExprRewriter exprRewriter = new ExprRewriter(values);
        ExprList having = exprRewriter.rewrite(new ExprList(this.query.getHavingExprs()));
        List<SortCondition> orderBy = exprRewriter.rewriteSortConditionList(this.query.getOrderBy());
        VarExprList groupBy = exprRewriter.rewrite(this.query.getGroupBy());
        this.query.getHavingExprs().clear();
        this.query.getHavingExprs().addAll(having.getList());
        if (orderBy != null) {
            if (this.query.getOrderBy() == null) {
                for (SortCondition sc : orderBy) {
                    this.query.addOrderBy(sc);
                }
            } else {
                this.query.getOrderBy().clear();
                this.query.getOrderBy().addAll(orderBy);
            }
        }
        this.query.getGroupBy().clear();
        this.query.getGroupBy().addAll(groupBy);
    }

    @Override
    public void build() {
    }
}

