/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortComparator;

public class ShortHeaps {
    private ShortHeaps() {
    }

    public static int downHeap(short[] heap, int size, int i, ShortComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        short e = heap[i];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && heap[child + 1] < heap[child]) {
                    ++child;
                }
                if (e > heap[child]) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(heap[child + 1], heap[child]) < 0) {
                    ++child;
                }
                if (c.compare(e, heap[child]) > 0) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(short[] heap, int size, int i, ShortComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        short e = heap[i];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && heap[parent] > e) {
                heap[i] = heap[parent];
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(heap[parent], e) > 0) {
                heap[i] = heap[parent];
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(short[] heap, int size, ShortComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            ShortHeaps.downHeap(heap, size, i, c);
        }
    }
}

