"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class EventbridgeToSns extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the EventbridgeToSns class.
     * @access public
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        defaults.CheckProps(props);
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the sns topic.
        [this.snsTopic, this.encryptionKey] = defaults.buildTopic(this, {
            existingTopicObj: props.existingTopicObj,
            topicProps: props.topicProps,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        // Setup the event rule target as sns topic.
        const topicEventTarget = {
            bind: () => ({
                id: this.snsTopic.topicName,
                arn: this.snsTopic.topicArn
            })
        };
        // Setup up the event rule property.
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([topicEventTarget]);
        const eventsRuleProps = core_2.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Setup up the event rule.
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        // Setup up the grant policy for event to be able to publish to the sns topic.
        this.snsTopic.grantPublish(new aws_iam_1.ServicePrincipal('events.amazonaws.com'));
        // Grant EventBridge service access to the SNS Topic encryption key
        (_b = this.encryptionKey) === null || _b === void 0 ? void 0 : _b.grant(new aws_iam_1.ServicePrincipal('events.amazonaws.com'), "kms:Decrypt", "kms:Encrypt", "kms:ReEncrypt*", "kms:GenerateDataKey*");
    }
}
exports.EventbridgeToSns = EventbridgeToSns;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToSns[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-sns.EventbridgeToSns", version: "1.119.0" };
//# sourceMappingURL=data:application/json;base64,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