# coding: utf-8

"""
    Xero Payroll AU

    This is the Xero Payroll API for orgs in Australia region.  # noqa: E501

    OpenAPI spec version: 2.2.11
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class ReimbursementLine(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "reimbursement_type_id": "str",
        "amount": "float",
        "description": "str",
        "expense_account": "str",
    }

    attribute_map = {
        "reimbursement_type_id": "ReimbursementTypeID",
        "amount": "Amount",
        "description": "Description",
        "expense_account": "ExpenseAccount",
    }

    def __init__(
        self,
        reimbursement_type_id=None,
        amount=None,
        description=None,
        expense_account=None,
    ):  # noqa: E501
        """ReimbursementLine - a model defined in OpenAPI"""  # noqa: E501

        self._reimbursement_type_id = None
        self._amount = None
        self._description = None
        self._expense_account = None
        self.discriminator = None

        if reimbursement_type_id is not None:
            self.reimbursement_type_id = reimbursement_type_id
        if amount is not None:
            self.amount = amount
        if description is not None:
            self.description = description
        if expense_account is not None:
            self.expense_account = expense_account

    @property
    def reimbursement_type_id(self):
        """Gets the reimbursement_type_id of this ReimbursementLine.  # noqa: E501

        Xero reimbursement type identifier  # noqa: E501

        :return: The reimbursement_type_id of this ReimbursementLine.  # noqa: E501
        :rtype: str
        """
        return self._reimbursement_type_id

    @reimbursement_type_id.setter
    def reimbursement_type_id(self, reimbursement_type_id):
        """Sets the reimbursement_type_id of this ReimbursementLine.

        Xero reimbursement type identifier  # noqa: E501

        :param reimbursement_type_id: The reimbursement_type_id of this ReimbursementLine.  # noqa: E501
        :type: str
        """

        self._reimbursement_type_id = reimbursement_type_id

    @property
    def amount(self):
        """Gets the amount of this ReimbursementLine.  # noqa: E501

        Reimbursement type amount  # noqa: E501

        :return: The amount of this ReimbursementLine.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this ReimbursementLine.

        Reimbursement type amount  # noqa: E501

        :param amount: The amount of this ReimbursementLine.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def description(self):
        """Gets the description of this ReimbursementLine.  # noqa: E501

        Reimbursement lines description (max length 50)  # noqa: E501

        :return: The description of this ReimbursementLine.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ReimbursementLine.

        Reimbursement lines description (max length 50)  # noqa: E501

        :param description: The description of this ReimbursementLine.  # noqa: E501
        :type: str
        """
        if description is not None and len(description) > 50:
            raise ValueError(
                "Invalid value for `description`, "
                "length must be less than or equal to `50`"
            )  # noqa: E501

        self._description = description

    @property
    def expense_account(self):
        """Gets the expense_account of this ReimbursementLine.  # noqa: E501

        Reimbursement expense account. For posted pay run you should be able to see expense account code.  # noqa: E501

        :return: The expense_account of this ReimbursementLine.  # noqa: E501
        :rtype: str
        """
        return self._expense_account

    @expense_account.setter
    def expense_account(self, expense_account):
        """Sets the expense_account of this ReimbursementLine.

        Reimbursement expense account. For posted pay run you should be able to see expense account code.  # noqa: E501

        :param expense_account: The expense_account of this ReimbursementLine.  # noqa: E501
        :type: str
        """

        self._expense_account = expense_account
