# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['libspn_keras',
 'libspn_keras.config',
 'libspn_keras.constraints',
 'libspn_keras.initializers',
 'libspn_keras.layers',
 'libspn_keras.losses',
 'libspn_keras.math',
 'libspn_keras.metrics',
 'libspn_keras.models',
 'libspn_keras.optimizers']

package_data = \
{'': ['*']}

install_requires = \
['colorlover>=0.3.0,<0.4.0',
 'plotly>=4.9.0,<5.0.0',
 'tensorflow-probability>=0.11,<0.12',
 'tensorflow>=2.3,<3.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.7.0,<2.0.0']}

setup_kwargs = {
    'name': 'libspn-keras',
    'version': '0.5.2',
    'description': 'LibSPN-Keras: A fledxible and scalable library for layer-based building and training of Sum-Product Networks',
    'long_description': '[![Python](https://img.shields.io/pypi/pyversions/libspn-keras.svg?style=plastic)](https://badge.fury.io/py/libspn-keras)\n[![tests](https://github.com/pronobis/libspn-keras/workflows/Tests/badge.svg)](https://github.com/pronobis/libspn-keras/actions?workflow=tests)\n[![PyPI](https://img.shields.io/pypi/v/libspn-keras.svg)](https://pypi.org/project/libspn-keras/)\n[![Read the Docs](https://readthedocs.org/projects/libspn-keras/badge/)](https://libspn-keras.readthedocs.io/)\n\n# LibSPN Keras\nLibSPN Keras is a library for constructing and training Sum-Product Networks. By leveraging the\nKeras framework with a TensorFlow backend, it offers both ease-of-use and scalability. Whereas the\npreviously available `libspn` focused on scalability, `libspn-keras` offers scalability **and**\na straightforward Keras-compatible interface.\n\n![](logo.png "LibSPN Keras logo")\n\n## Contents\n* [API Reference](reference.md)\n\n## Documentation\nThe documentation of the library is hosted on [ReadTheDocs](https://libspn-keras.readthedocs.io/en/latest/index.html).\n\n## What are SPNs?\n\nSum-Product Networks (SPNs) are a probabilistic deep architecture with solid theoretical\nfoundations, which demonstrated state-of-the-art performance in several domains. Yet, surprisingly,\nthere are no mature, general-purpose SPN implementations that would serve as a platform for the\ncommunity of machine learning researchers centered around SPNs. LibSPN Keras is a new\ngeneral-purpose Python library, which aims to become such a platform. The library is designed to\nmake it straightforward and effortless to apply various SPN architectures to large-scale datasets\nand problems. The library achieves scalability and efficiency, thanks to a tight coupling with\nTensorFlow and Keras, two frameworks already in use by a large community of researchers and\ndevelopers in multiple domains.\n\n## Dependencies\nCurrently, LibSPN Keras is tested with `tensorflow>=2.0` and `tensorflow-probability>=0.8.0`.\n\n## Installation\n\n```\npip install libspn-keras\n```\n\n## Note on stability of the repo\nCurrently, the repo is in an alpha state. Hence, one can expect some sporadic breaking changes.\n\n## Feature Overview\n- Gradient based training for generative and discriminative problems\n- Hard EM training for generative problems\n- Hard EM training with unweighted weights for generative problems\n- Soft EM training for generative problems\n- [Deep Generalized Convolutional Sum-Product Networks](https://arxiv.org/abs/1902.06155)\n- SPNs with arbitrary decompositions\n- Fully compatible with Keras and TensorFlow 2.0\n- Input dropout\n- Sum child dropout\n- Image completion\n- Model saving\n- Discrete inputs through an `IndicatorLeaf` node\n- Continuous inputs through `NormalLeaf`, `CauchyLeaf` or `LaplaceLeaf`. Each of these distributions support both\nunivariate as well as *multivariate* inputs.\n\n## Examples / Tutorials\n1. **Benchmark**: `libspn-keras` and Einsum Networks. [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pronobis/libspn-keras/blob/master/examples/notebooks/Benchmark%20With%20Einsum%20Networks.ipynb)\n2. **Image Classification**: A Deep Generalized Convolutional Sum-Product Network (DGC-SPN). [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pronobis/libspn-keras/blob/master/examples/notebooks/DGC-SPN%20Image%20Classification.ipynb)\n3. **Image Completion**: A Deep Generalized Convolutional Sum-Product Network (DGC-SPN). [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pronobis/libspn-keras/blob/master/examples/notebooks/DGC-SPN%20Image%20Completion.ipynb)\n4. **Understanding region SPNs** [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pronobis/libspn-keras/blob/master/examples/notebooks/Understanding%20Region%20SPNs.ipynb)\n5. More to come, and if you would like to see a tutorial on anything in particular\nplease raise an issue!\n\nCheck out the way we can build complex DGC-SPNs in a layer-wise fashion:\n```python\nimport libspn_keras as spnk\nfrom tensorflow import keras\n\nspnk.set_default_sum_op(spnk.SumOpGradBackprop())\nspnk.set_default_accumulator_initializer(\n    keras.initializers.TruncatedNormal(stddev=0.5, mean=1.0)\n)\n\nsum_product_network = keras.Sequential([\n  spnk.layers.NormalizeStandardScore(input_shape=(28, 28, 1)),\n  spnk.layers.NormalLeaf(\n      num_components=16,\n      location_trainable=True,\n      location_initializer=keras.initializers.TruncatedNormal(\n          stddev=1.0, mean=0.0)\n  ),\n  # Non-overlapping products\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[2, 2],\n      dilations=[1, 1],\n      kernel_size=[2, 2],\n      padding=\'valid\'\n  ),\n  spnk.layers.Local2DSum(num_sums=16),\n  # Non-overlapping products\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[2, 2],\n      dilations=[1, 1],\n      kernel_size=[2, 2],\n      padding=\'valid\'\n  ),\n  spnk.layers.Local2DSum(num_sums=32),\n  # Overlapping products, starting at dilations [1, 1]\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[1, 1],\n      dilations=[1, 1],\n      kernel_size=[2, 2],\n      padding=\'full\'\n  ),\n  spnk.layers.Local2DSum(num_sums=32),\n  # Overlapping products, with dilations [2, 2] and full padding\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[1, 1],\n      dilations=[2, 2],\n      kernel_size=[2, 2],\n      padding=\'full\'\n  ),\n  spnk.layers.Local2DSum(num_sums=64),\n  # Overlapping products, with dilations [2, 2] and full padding\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[1, 1],\n      dilations=[4, 4],\n      kernel_size=[2, 2],\n      padding=\'full\'\n  ),\n  spnk.layers.Local2DSum(num_sums=64),\n  # Overlapping products, with dilations [2, 2] and \'final\' padding to combine\n  # all scopes\n  spnk.layers.Conv2DProduct(\n      depthwise=True,\n      strides=[1, 1],\n      dilations=[8, 8],\n      kernel_size=[2, 2],\n      padding=\'final\'\n  ),\n  spnk.layers.SpatialToRegions(),\n  # Class roots\n  spnk.layers.DenseSum(num_sums=10),\n  spnk.layers.RootSum(return_weighted_child_logits=True)\n])\n\nsum_product_network.summary(line_length=100)\n```\n\nWhich produces:\n```\nModel: "sequential"\n_________________________________________________________________\nLayer (type)                 Output Shape              Param #\n=================================================================\nnormal_leaf (NormalLeaf)     (None, 28, 28, 16)        25088\n_________________________________________________________________\nconv2d_product (Conv2DProduc (None, 14, 14, 16)        4\n_________________________________________________________________\nlocal2d_sum (Local2DSum)     (None, 14, 14, 16)        50176\n_________________________________________________________________\nconv2d_product_1 (Conv2DProd (None, 7, 7, 16)          4\n_________________________________________________________________\nlocal2d_sum_1 (Local2DSum)   (None, 7, 7, 32)          25088\n_________________________________________________________________\nconv2d_product_2 (Conv2DProd (None, 8, 8, 32)          4\n_________________________________________________________________\nlocal2d_sum_2 (Local2DSum)   (None, 8, 8, 32)          65536\n_________________________________________________________________\nconv2d_product_3 (Conv2DProd (None, 10, 10, 32)        4\n_________________________________________________________________\nlocal2d_sum_3 (Local2DSum)   (None, 10, 10, 64)        204800\n_________________________________________________________________\nconv2d_product_4 (Conv2DProd (None, 14, 14, 64)        4\n_________________________________________________________________\nlocal2d_sum_4 (Local2DSum)   (None, 14, 14, 64)        802816\n_________________________________________________________________\nconv2d_product_5 (Conv2DProd (None, 8, 8, 64)          4\n_________________________________________________________________\nspatial_to_regions (SpatialT (None, 1, 1, 4096)        0\n_________________________________________________________________\ndense_sum (DenseSum)         (None, 1, 1, 10)          40960\n_________________________________________________________________\nroot_sum (RootSum)           (None, 10)                10\n=================================================================\nTotal params: 1,214,498\nTrainable params: 1,201,930\nNon-trainable params: 12,568\n_________________________________________________________________\n```\n\n## TODOs\n- Structure learning\n- Advanced regularization e.g. pruning or auxiliary losses on weight accumulators\n',
    'author': 'Jos van de Wolfshaar',
    'author_email': 'jos.vandewolfshaar@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pronobis/libspn-keras',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
