"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const eks = require("../lib");
const k8s_object_value_1 = require("../lib/k8s-object-value");
const CLUSTER_VERSION = eks.KubernetesVersion.V1_16;
module.exports = {
    'creates the correct custom resource with explicit values for all properties'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const cluster = new eks.Cluster(stack, 'MyCluster', { version: CLUSTER_VERSION });
        // WHEN
        const attribute = new k8s_object_value_1.KubernetesObjectValue(stack, 'MyAttribute', {
            cluster: cluster,
            jsonPath: '.status',
            objectName: 'mydeployment',
            objectType: 'deployment',
            objectNamespace: 'mynamespace',
            timeout: core_1.Duration.seconds(5),
        });
        const expectedCustomResourceId = 'MyAttributeF1E9B10D';
        test.deepEqual(assert_1.expect(stack).value.Resources[expectedCustomResourceId], {
            Type: 'Custom::AWSCDK-EKS-KubernetesObjectValue',
            Properties: {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.awscdkawseksKubectlProviderframeworkonEvent0A650005Arn',
                    ],
                },
                ClusterName: { Ref: 'MyCluster8AD82BF8' },
                RoleArn: { 'Fn::GetAtt': ['MyClusterCreationRoleB5FA4FF3', 'Arn'] },
                ObjectType: 'deployment',
                ObjectName: 'mydeployment',
                ObjectNamespace: 'mynamespace',
                JsonPath: '.status',
                TimeoutSeconds: 5,
            },
            DependsOn: ['MyClusterKubectlReadyBarrier7547948A'],
            UpdateReplacePolicy: 'Delete',
            DeletionPolicy: 'Delete',
        });
        test.deepEqual(stack.resolve(attribute.value), { 'Fn::GetAtt': [expectedCustomResourceId, 'Value'] });
        test.done();
    },
    'creates the correct custom resource with defaults'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const cluster = new eks.Cluster(stack, 'MyCluster', { version: CLUSTER_VERSION });
        // WHEN
        const attribute = new k8s_object_value_1.KubernetesObjectValue(stack, 'MyAttribute', {
            cluster: cluster,
            jsonPath: '.status',
            objectName: 'mydeployment',
            objectType: 'deployment',
        });
        const expectedCustomResourceId = 'MyAttributeF1E9B10D';
        test.deepEqual(assert_1.expect(stack).value.Resources[expectedCustomResourceId], {
            Type: 'Custom::AWSCDK-EKS-KubernetesObjectValue',
            Properties: {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.awscdkawseksKubectlProviderframeworkonEvent0A650005Arn',
                    ],
                },
                ClusterName: { Ref: 'MyCluster8AD82BF8' },
                RoleArn: { 'Fn::GetAtt': ['MyClusterCreationRoleB5FA4FF3', 'Arn'] },
                ObjectType: 'deployment',
                ObjectName: 'mydeployment',
                ObjectNamespace: 'default',
                JsonPath: '.status',
                TimeoutSeconds: 300,
            },
            DependsOn: ['MyClusterKubectlReadyBarrier7547948A'],
            UpdateReplacePolicy: 'Delete',
            DeletionPolicy: 'Delete',
        });
        test.deepEqual(stack.resolve(attribute.value), { 'Fn::GetAtt': [expectedCustomResourceId, 'Value'] });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5rOHMtb2JqZWN0LXZhbHVlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC5rOHMtb2JqZWN0LXZhbHVlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSw0Q0FBeUM7QUFDekMsd0NBQWdEO0FBRWhELDhCQUE4QjtBQUM5Qiw4REFBZ0U7QUFFaEUsTUFBTSxlQUFlLEdBQUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQztBQUVwRCxpQkFBUztJQUVQLDZFQUE2RSxDQUFDLElBQVU7UUFDdEYsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxFQUFFLENBQUM7UUFDMUIsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUUsRUFBRSxPQUFPLEVBQUUsZUFBZSxFQUFFLENBQUMsQ0FBQztRQUVsRixPQUFPO1FBQ1AsTUFBTSxTQUFTLEdBQUcsSUFBSSx3Q0FBcUIsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO1lBQ2hFLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFFBQVEsRUFBRSxTQUFTO1lBQ25CLFVBQVUsRUFBRSxjQUFjO1lBQzFCLFVBQVUsRUFBRSxZQUFZO1lBQ3hCLGVBQWUsRUFBRSxhQUFhO1lBQzlCLE9BQU8sRUFBRSxlQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztTQUM3QixDQUFDLENBQUM7UUFFSCxNQUFNLHdCQUF3QixHQUFHLHFCQUFxQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxTQUFTLENBQUMsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsd0JBQXdCLENBQUMsRUFBRTtZQUN0RSxJQUFJLEVBQUUsMENBQTBDO1lBQ2hELFVBQVUsRUFBRTtnQkFDVixZQUFZLEVBQUU7b0JBQ1osWUFBWSxFQUFFO3dCQUNaLDhGQUE4Rjt3QkFDOUYsZ0VBQWdFO3FCQUNqRTtpQkFDRjtnQkFDRCxXQUFXLEVBQUUsRUFBRSxHQUFHLEVBQUUsbUJBQW1CLEVBQUU7Z0JBQ3pDLE9BQU8sRUFBRSxFQUFFLFlBQVksRUFBRSxDQUFDLCtCQUErQixFQUFFLEtBQUssQ0FBQyxFQUFFO2dCQUNuRSxVQUFVLEVBQUUsWUFBWTtnQkFDeEIsVUFBVSxFQUFFLGNBQWM7Z0JBQzFCLGVBQWUsRUFBRSxhQUFhO2dCQUM5QixRQUFRLEVBQUUsU0FBUztnQkFDbkIsY0FBYyxFQUFFLENBQUM7YUFDbEI7WUFDRCxTQUFTLEVBQUUsQ0FBQyxzQ0FBc0MsQ0FBQztZQUNuRCxtQkFBbUIsRUFBRSxRQUFRO1lBQzdCLGNBQWMsRUFBRSxRQUFRO1NBQ3pCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEVBQUUsRUFBRSxZQUFZLEVBQUUsQ0FBQyx3QkFBd0IsRUFBRSxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDdEcsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELG1EQUFtRCxDQUFDLElBQVU7UUFDNUQsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxFQUFFLENBQUM7UUFDMUIsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUUsRUFBRSxPQUFPLEVBQUUsZUFBZSxFQUFFLENBQUMsQ0FBQztRQUVsRixPQUFPO1FBQ1AsTUFBTSxTQUFTLEdBQUcsSUFBSSx3Q0FBcUIsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO1lBQ2hFLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFFBQVEsRUFBRSxTQUFTO1lBQ25CLFVBQVUsRUFBRSxjQUFjO1lBQzFCLFVBQVUsRUFBRSxZQUFZO1NBQ3pCLENBQUMsQ0FBQztRQUVILE1BQU0sd0JBQXdCLEdBQUcscUJBQXFCLENBQUM7UUFDdkQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxFQUFFO1lBQ3RFLElBQUksRUFBRSwwQ0FBMEM7WUFDaEQsVUFBVSxFQUFFO2dCQUNWLFlBQVksRUFBRTtvQkFDWixZQUFZLEVBQUU7d0JBQ1osOEZBQThGO3dCQUM5RixnRUFBZ0U7cUJBQ2pFO2lCQUNGO2dCQUNELFdBQVcsRUFBRSxFQUFFLEdBQUcsRUFBRSxtQkFBbUIsRUFBRTtnQkFDekMsT0FBTyxFQUFFLEVBQUUsWUFBWSxFQUFFLENBQUMsK0JBQStCLEVBQUUsS0FBSyxDQUFDLEVBQUU7Z0JBQ25FLFVBQVUsRUFBRSxZQUFZO2dCQUN4QixVQUFVLEVBQUUsY0FBYztnQkFDMUIsZUFBZSxFQUFFLFNBQVM7Z0JBQzFCLFFBQVEsRUFBRSxTQUFTO2dCQUNuQixjQUFjLEVBQUUsR0FBRzthQUNwQjtZQUNELFNBQVMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDO1lBQ25ELG1CQUFtQixFQUFFLFFBQVE7WUFDN0IsY0FBYyxFQUFFLFFBQVE7U0FDekIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsRUFBRSxFQUFFLFlBQVksRUFBRSxDQUFDLHdCQUF3QixFQUFFLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUN0RyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBRUYsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGV4cGVjdCB9IGZyb20gJ0Bhd3MtY2RrL2Fzc2VydCc7XG5pbXBvcnQgeyBTdGFjaywgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgKiBhcyBla3MgZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IEt1YmVybmV0ZXNPYmplY3RWYWx1ZSB9IGZyb20gJy4uL2xpYi9rOHMtb2JqZWN0LXZhbHVlJztcblxuY29uc3QgQ0xVU1RFUl9WRVJTSU9OID0gZWtzLkt1YmVybmV0ZXNWZXJzaW9uLlYxXzE2O1xuXG5leHBvcnQgPSB7XG5cbiAgJ2NyZWF0ZXMgdGhlIGNvcnJlY3QgY3VzdG9tIHJlc291cmNlIHdpdGggZXhwbGljaXQgdmFsdWVzIGZvciBhbGwgcHJvcGVydGllcycodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCBjbHVzdGVyID0gbmV3IGVrcy5DbHVzdGVyKHN0YWNrLCAnTXlDbHVzdGVyJywgeyB2ZXJzaW9uOiBDTFVTVEVSX1ZFUlNJT04gfSk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3QgYXR0cmlidXRlID0gbmV3IEt1YmVybmV0ZXNPYmplY3RWYWx1ZShzdGFjaywgJ015QXR0cmlidXRlJywge1xuICAgICAgY2x1c3RlcjogY2x1c3RlcixcbiAgICAgIGpzb25QYXRoOiAnLnN0YXR1cycsXG4gICAgICBvYmplY3ROYW1lOiAnbXlkZXBsb3ltZW50JyxcbiAgICAgIG9iamVjdFR5cGU6ICdkZXBsb3ltZW50JyxcbiAgICAgIG9iamVjdE5hbWVzcGFjZTogJ215bmFtZXNwYWNlJyxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMoNSksXG4gICAgfSk7XG5cbiAgICBjb25zdCBleHBlY3RlZEN1c3RvbVJlc291cmNlSWQgPSAnTXlBdHRyaWJ1dGVGMUU5QjEwRCc7XG4gICAgdGVzdC5kZWVwRXF1YWwoZXhwZWN0KHN0YWNrKS52YWx1ZS5SZXNvdXJjZXNbZXhwZWN0ZWRDdXN0b21SZXNvdXJjZUlkXSwge1xuICAgICAgVHlwZTogJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzT2JqZWN0VmFsdWUnLFxuICAgICAgUHJvcGVydGllczoge1xuICAgICAgICBTZXJ2aWNlVG9rZW46IHtcbiAgICAgICAgICAnRm46OkdldEF0dCc6IFtcbiAgICAgICAgICAgICdhd3NjZGthd3Nla3NLdWJlY3RsUHJvdmlkZXJOZXN0ZWRTdGFja2F3c2Nka2F3c2Vrc0t1YmVjdGxQcm92aWRlck5lc3RlZFN0YWNrUmVzb3VyY2VBN0FFQkE2QicsXG4gICAgICAgICAgICAnT3V0cHV0cy5hd3NjZGthd3Nla3NLdWJlY3RsUHJvdmlkZXJmcmFtZXdvcmtvbkV2ZW50MEE2NTAwMDVBcm4nLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIENsdXN0ZXJOYW1lOiB7IFJlZjogJ015Q2x1c3RlcjhBRDgyQkY4JyB9LFxuICAgICAgICBSb2xlQXJuOiB7ICdGbjo6R2V0QXR0JzogWydNeUNsdXN0ZXJDcmVhdGlvblJvbGVCNUZBNEZGMycsICdBcm4nXSB9LFxuICAgICAgICBPYmplY3RUeXBlOiAnZGVwbG95bWVudCcsXG4gICAgICAgIE9iamVjdE5hbWU6ICdteWRlcGxveW1lbnQnLFxuICAgICAgICBPYmplY3ROYW1lc3BhY2U6ICdteW5hbWVzcGFjZScsXG4gICAgICAgIEpzb25QYXRoOiAnLnN0YXR1cycsXG4gICAgICAgIFRpbWVvdXRTZWNvbmRzOiA1LFxuICAgICAgfSxcbiAgICAgIERlcGVuZHNPbjogWydNeUNsdXN0ZXJLdWJlY3RsUmVhZHlCYXJyaWVyNzU0Nzk0OEEnXSxcbiAgICAgIFVwZGF0ZVJlcGxhY2VQb2xpY3k6ICdEZWxldGUnLFxuICAgICAgRGVsZXRpb25Qb2xpY3k6ICdEZWxldGUnLFxuICAgIH0pO1xuXG4gICAgdGVzdC5kZWVwRXF1YWwoc3RhY2sucmVzb2x2ZShhdHRyaWJ1dGUudmFsdWUpLCB7ICdGbjo6R2V0QXR0JzogW2V4cGVjdGVkQ3VzdG9tUmVzb3VyY2VJZCwgJ1ZhbHVlJ10gfSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2NyZWF0ZXMgdGhlIGNvcnJlY3QgY3VzdG9tIHJlc291cmNlIHdpdGggZGVmYXVsdHMnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG4gICAgY29uc3QgY2x1c3RlciA9IG5ldyBla3MuQ2x1c3RlcihzdGFjaywgJ015Q2x1c3RlcicsIHsgdmVyc2lvbjogQ0xVU1RFUl9WRVJTSU9OIH0pO1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IGF0dHJpYnV0ZSA9IG5ldyBLdWJlcm5ldGVzT2JqZWN0VmFsdWUoc3RhY2ssICdNeUF0dHJpYnV0ZScsIHtcbiAgICAgIGNsdXN0ZXI6IGNsdXN0ZXIsXG4gICAgICBqc29uUGF0aDogJy5zdGF0dXMnLFxuICAgICAgb2JqZWN0TmFtZTogJ215ZGVwbG95bWVudCcsXG4gICAgICBvYmplY3RUeXBlOiAnZGVwbG95bWVudCcsXG4gICAgfSk7XG5cbiAgICBjb25zdCBleHBlY3RlZEN1c3RvbVJlc291cmNlSWQgPSAnTXlBdHRyaWJ1dGVGMUU5QjEwRCc7XG4gICAgdGVzdC5kZWVwRXF1YWwoZXhwZWN0KHN0YWNrKS52YWx1ZS5SZXNvdXJjZXNbZXhwZWN0ZWRDdXN0b21SZXNvdXJjZUlkXSwge1xuICAgICAgVHlwZTogJ0N1c3RvbTo6QVdTQ0RLLUVLUy1LdWJlcm5ldGVzT2JqZWN0VmFsdWUnLFxuICAgICAgUHJvcGVydGllczoge1xuICAgICAgICBTZXJ2aWNlVG9rZW46IHtcbiAgICAgICAgICAnRm46OkdldEF0dCc6IFtcbiAgICAgICAgICAgICdhd3NjZGthd3Nla3NLdWJlY3RsUHJvdmlkZXJOZXN0ZWRTdGFja2F3c2Nka2F3c2Vrc0t1YmVjdGxQcm92aWRlck5lc3RlZFN0YWNrUmVzb3VyY2VBN0FFQkE2QicsXG4gICAgICAgICAgICAnT3V0cHV0cy5hd3NjZGthd3Nla3NLdWJlY3RsUHJvdmlkZXJmcmFtZXdvcmtvbkV2ZW50MEE2NTAwMDVBcm4nLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICAgIENsdXN0ZXJOYW1lOiB7IFJlZjogJ015Q2x1c3RlcjhBRDgyQkY4JyB9LFxuICAgICAgICBSb2xlQXJuOiB7ICdGbjo6R2V0QXR0JzogWydNeUNsdXN0ZXJDcmVhdGlvblJvbGVCNUZBNEZGMycsICdBcm4nXSB9LFxuICAgICAgICBPYmplY3RUeXBlOiAnZGVwbG95bWVudCcsXG4gICAgICAgIE9iamVjdE5hbWU6ICdteWRlcGxveW1lbnQnLFxuICAgICAgICBPYmplY3ROYW1lc3BhY2U6ICdkZWZhdWx0JyxcbiAgICAgICAgSnNvblBhdGg6ICcuc3RhdHVzJyxcbiAgICAgICAgVGltZW91dFNlY29uZHM6IDMwMCxcbiAgICAgIH0sXG4gICAgICBEZXBlbmRzT246IFsnTXlDbHVzdGVyS3ViZWN0bFJlYWR5QmFycmllcjc1NDc5NDhBJ10sXG4gICAgICBVcGRhdGVSZXBsYWNlUG9saWN5OiAnRGVsZXRlJyxcbiAgICAgIERlbGV0aW9uUG9saWN5OiAnRGVsZXRlJyxcbiAgICB9KTtcblxuICAgIHRlc3QuZGVlcEVxdWFsKHN0YWNrLnJlc29sdmUoYXR0cmlidXRlLnZhbHVlKSwgeyAnRm46OkdldEF0dCc6IFtleHBlY3RlZEN1c3RvbVJlc291cmNlSWQsICdWYWx1ZSddIH0pO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG59O1xuIl19